/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.component;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.config.PrettyConfig;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.util.UrlPatternParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyUrlBuilder {
    public List<UIParameter> extractParameters(UIComponent component) {
        ArrayList<UIParameter> results = new ArrayList<UIParameter>();
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            results.add((UIParameter)child);
        }
        return results;
    }

    public String buildMappedUrl(UIComponent component) {
        String mappingId = (String)component.getAttributes().get("mappingId");
        if (mappingId == null) {
            throw new PrettyException("Mapping id was null when attempting to build URL for component: " + component.toString() + " <" + component.getClientId(FacesContext.getCurrentInstance()) + ">");
        }
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        PrettyConfig prettyConfig = prettyContext.getConfig();
        PrettyUrlMapping urlMapping = prettyConfig.getMappingById(mappingId);
        return this.buildMappedUrl(urlMapping, this.extractParameters(component));
    }

    public String buildMappedUrl(PrettyUrlMapping urlMapping, List<UIParameter> params) {
        if (urlMapping != null) {
            UrlPatternParser parser = new UrlPatternParser(urlMapping.getPattern());
            ArrayList<String> linkParams = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            boolean paramWritten = false;
            if (params.size() == 1 && (params.get(0).getValue() instanceof List || params.get(0).getValue() == null)) {
                return parser.getMappedUrl(params.get(0).getValue());
            }
            for (UIParameter parameter : params) {
                try {
                    String name = parameter.getName();
                    Object value = parameter.getValue();
                    if (name != null && value != null) {
                        String pv = value.toString();
                        sb.append(paramWritten ? (char)'&' : '?');
                        sb.append(URLEncoder.encode(name.toString(), "UTF-8"));
                        sb.append('=');
                        if (pv != null && pv.length() != 0) {
                            sb.append(URLEncoder.encode(pv, "UTF-8"));
                        }
                        paramWritten = true;
                        continue;
                    }
                    if (value == null) continue;
                    linkParams.add(URLEncoder.encode(value.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new PrettyException(e);
                }
            }
            return String.valueOf(parser.getMappedUrl(linkParams.toArray())) + sb.toString();
        }
        return "";
    }
}

