/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.config;

import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.util.UrlPatternParser;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyConfig {
    public static final String CONFIG_REQUEST_KEY = "pretty_CONFIG_REQUEST_KEY";
    private List<PrettyUrlMapping> mappings = new ArrayList<PrettyUrlMapping>();

    public List<PrettyUrlMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<PrettyUrlMapping> mappings) {
        this.mappings = mappings;
    }

    public void addMapping(PrettyUrlMapping mapping) {
        this.mappings.add(mapping);
    }

    public PrettyUrlMapping getMappingForUrl(String url) {
        for (PrettyUrlMapping mapping : this.getMappings()) {
            String urlPattern = mapping.getPattern();
            UrlPatternParser um = new UrlPatternParser(urlPattern);
            if (!um.matches(url)) continue;
            return mapping;
        }
        return null;
    }

    public boolean isMappingId(String action) {
        PrettyUrlMapping mapping = this.getMappingById(action);
        return mapping instanceof PrettyUrlMapping;
    }

    public boolean isURLMapped(String url) {
        PrettyUrlMapping mapping = this.getMappingForUrl(url);
        return mapping != null;
    }

    public boolean isViewMapped(String viewId) {
        if (viewId != null) {
            viewId = viewId.trim();
            PrettyUrlMapping needle = new PrettyUrlMapping();
            needle.setViewId(viewId);
            if (viewId.startsWith("/")) {
                if (this.getMappings().contains(needle)) {
                    return true;
                }
                needle.setViewId(viewId.substring(1));
            }
            return this.getMappings().contains(needle);
        }
        return false;
    }

    public PrettyUrlMapping getMappingById(String id) {
        if (id != null) {
            if (id.startsWith("pretty:")) {
                id = id.substring("pretty:".length());
            }
            for (PrettyUrlMapping mapping : this.getMappings()) {
                if (!mapping.getId().equals(id)) continue;
                return mapping;
            }
        }
        return null;
    }
}

