/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.config;

import com.ocpsoft.pretty.config.DigesterPrettyConfigParser;
import com.ocpsoft.pretty.config.PrettyConfig;
import com.ocpsoft.pretty.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.config.PrettyConfigParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyConfigurator {
    private static final Log log = LogFactory.getLog(PrettyConfigurator.class);
    public static final String PRETTY_CONFIG_RESOURCE = "META-INF/pretty-config.xml";
    public static final String DEFAULT_PRETTY_FACES_CONFIG = "/WEB-INF/pretty-config.xml";
    private final ServletContext servletContext;
    private final PrettyConfigParser configParser;

    public PrettyConfigurator(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException("Servlet context must not be null.");
        }
        this.servletContext = servletContext;
        this.configParser = new DigesterPrettyConfigParser();
    }

    public PrettyConfig configure() throws IOException, SAXException {
        PrettyConfigBuilder builder = new PrettyConfigBuilder();
        this.feedClassLoaderConfigs(builder);
        this.feedContextSpecifiedConfig(builder);
        this.feedWebAppConfig(builder);
        return builder.build();
    }

    private void feedClassLoaderConfigs(PrettyConfigBuilder builder) throws IOException, SAXException {
        Enumeration<URL> urls = this.getResourceLoader().getResources(PRETTY_CONFIG_RESOURCE);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                InputStream is = null;
                try {
                    is = this.openStream(url);
                    this.configParser.parse(builder, is);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private void feedContextSpecifiedConfig(PrettyConfigBuilder builder) throws IOException, SAXException {
        List<String> configFilesList = this.getConfigFilesList();
        for (String systemId : configFilesList) {
            InputStream is = this.servletContext.getResourceAsStream(systemId);
            if (is == null) {
                log.error((Object)("Pretty Faces config resource [" + systemId + "] not found."));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading config [" + systemId + "]."));
            }
            try {
                this.configParser.parse(builder, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<String> getConfigFilesList() {
        String configFiles = this.servletContext.getInitParameter("com.ocpsoft.pretty.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_PRETTY_FACES_CONFIG.equals(systemId)) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"The file [/WEB-INF/pretty-config.xml] has been specified in the [com.ocpsoft.pretty.CONFIG_FILES] context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void feedWebAppConfig(PrettyConfigBuilder builder) throws IOException, SAXException {
        InputStream is = this.servletContext.getResourceAsStream(DEFAULT_PRETTY_FACES_CONFIG);
        if (is != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Reading config [/WEB-INF/pretty-config.xml].");
            }
            try {
                this.configParser.parse(builder, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected ClassLoader getResourceLoader() {
        ClassLoader resourceLoader = Thread.currentThread().getContextClassLoader();
        return resourceLoader;
    }

    protected InputStream openStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }
}

