/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.event;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.beans.ActionExecutor;
import com.ocpsoft.pretty.config.PrettyUrlMapping;
import com.ocpsoft.pretty.util.FacesMessagesUtils;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class PrettyPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 2345410822999587673L;
    private final FacesMessagesUtils messagesUtils = new FacesMessagesUtils();
    private final ActionExecutor executor = new ActionExecutor();

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (!PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            this.processEvent(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            FacesContext context = event.getFacesContext();
            this.messagesUtils.restoreMessages(context, context.getExternalContext().getRequestMap());
            this.processEvent(event);
        }
    }

    private void processEvent(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        PrettyUrlMapping mapping = prettyContext.getCurrentMapping();
        if (mapping != null) {
            this.executor.executeActions(context, event.getPhaseId(), mapping);
        }
    }
}

