/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.application.PrettyRedirector;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;

public class PrettyNavigationHandler
extends NavigationHandler {
    private static final Log log = LogFactory.getLog(PrettyNavigationHandler.class);
    private final NavigationHandler parent;
    private final PrettyRedirector pr = PrettyRedirector.getInstance();

    public PrettyNavigationHandler(NavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        log.debug("Navigation requested: fromAction [" + fromAction + "], outcome [" + outcome + "]");
        if (!this.pr.redirect(context, outcome)) {
            this.processFacesNavigation(context, fromAction, outcome);
        }
    }

    private void processFacesNavigation(FacesContext context, String fromAction, String outcome) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        log.debug("Not a PrettyFaces navigation string - passing control to default nav-handler");
        prettyContext.setInNavigation(true);
        String originalViewId = context.getViewRoot().getViewId();
        this.parent.handleNavigation(context, fromAction, outcome);
        String newViewId = context.getViewRoot().getViewId();
        if (context.getResponseComplete() || originalViewId.equals(newViewId)) {
            prettyContext.setInNavigation(false);
        }
    }
}

