/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.component.renderer;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.component.Link;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.util.PrettyURLBuilder;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class LinkRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "javax.faces.Link";
    private final PrettyURLBuilder urlBuilder = new PrettyURLBuilder();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        if (!component.isRendered()) {
            return;
        }
        Link link = (Link)component;
        ResponseWriter writer = context.getResponseWriter();
        if (link.isDisabled()) {
            writer.startElement("span", (UIComponent)link);
        } else {
            writer.startElement("a", (UIComponent)link);
        }
        String mappingId = (String)component.getAttributes().get("mappingId");
        if (mappingId == null) {
            throw new PrettyException("Mapping id was null when attempting to build URL for component: " + component.toString() + " <" + component.getClientId(context) + ">");
        }
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        PrettyConfig prettyConfig = prettyContext.getConfig();
        UrlMapping urlMapping = prettyConfig.getMappingById(mappingId);
        String href = context.getExternalContext().getRequestContextPath() + this.urlBuilder.build(urlMapping, true, this.urlBuilder.extractParameters(component));
        if (link.getAnchor() != null && link.getAnchor().length() > 0) {
            href = href + "#" + link.getAnchor();
        }
        writer.writeURIAttribute("href", (Object)context.getExternalContext().encodeResourceURL(href), "href");
        this.writeAttr(writer, "id", link.getClientId(context));
        this.writeAttr(writer, "accesskey", link.getAccesskey());
        this.writeAttr(writer, "charset", link.getCharset());
        this.writeAttr(writer, "coords", link.getCoords());
        this.writeAttr(writer, "dir", link.getDir());
        this.writeAttr(writer, "hreflang", link.getHreflang());
        this.writeAttr(writer, "lang", link.getLang());
        this.writeAttr(writer, "onblur", link.getOnblur());
        this.writeAttr(writer, "onclick", link.getOnclick());
        this.writeAttr(writer, "ondblclick", link.getOndblclick());
        this.writeAttr(writer, "onfocus", link.getOnfocus());
        this.writeAttr(writer, "onkeydown", link.getOnkeydown());
        this.writeAttr(writer, "onkeypress", link.getOnkeypress());
        this.writeAttr(writer, "onkeyup", link.getOnkeyup());
        this.writeAttr(writer, "onmousedown", link.getOnmousedown());
        this.writeAttr(writer, "onmousemove", link.getOnmousemove());
        this.writeAttr(writer, "onmouseout", link.getOnmouseout());
        this.writeAttr(writer, "onmouseover", link.getOnmouseover());
        this.writeAttr(writer, "onmouseup", link.getOnmouseup());
        this.writeAttr(writer, "rel", link.getRel());
        this.writeAttr(writer, "rev", link.getRev());
        this.writeAttr(writer, "shape", link.getShape());
        this.writeAttr(writer, "style", link.getStyle());
        this.writeAttr(writer, "class", link.getStyleClass());
        this.writeAttr(writer, "tabindex", link.getTabindex());
        this.writeAttr(writer, "target", link.getTarget());
        this.writeAttr(writer, "title", link.getTitle());
        this.writeAttr(writer, "type", link.getType());
    }

    private void writeAttr(ResponseWriter writer, String name, String value) throws IOException {
        if (value != null) {
            writer.writeAttribute(name, (Object)value, name);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Link link = (Link)component;
        super.encodeEnd(context, (UIComponent)link);
        if (!link.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        if (link.isDisabled()) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }
}

