/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config;

import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.url.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyConfig {
    public static final String CONFIG_REQUEST_KEY = "pretty_CONFIG_REQUEST_KEY";
    private List<UrlMapping> mappings = new ArrayList<UrlMapping>();
    private List<RewriteRule> globalRewriteRules = new ArrayList<RewriteRule>();
    private String dynaviewId = "";

    public void setDynaviewId(String facesDynaViewId) {
        this.dynaviewId = facesDynaViewId;
    }

    public String getDynaviewId() {
        return this.dynaviewId;
    }

    public List<RewriteRule> getGlobalRewriteRules() {
        return this.globalRewriteRules;
    }

    public void setGlobalRewriteRules(List<RewriteRule> rules) {
        this.globalRewriteRules = Collections.unmodifiableList(rules);
    }

    public List<UrlMapping> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public void setMappings(List<UrlMapping> mappings) {
        this.mappings = Collections.unmodifiableList(mappings);
    }

    public UrlMapping getMappingForUrl(URL url) {
        for (UrlMapping mapping : this.getMappings()) {
            if (!mapping.matches(url)) continue;
            return mapping;
        }
        return null;
    }

    public boolean isMappingId(String id) {
        UrlMapping mapping = this.getMappingById(id);
        return mapping instanceof UrlMapping;
    }

    public boolean isURLMapped(URL url) {
        UrlMapping mapping = this.getMappingForUrl(url);
        return mapping != null;
    }

    public boolean isViewMapped(String viewId) {
        if (viewId != null) {
            viewId = viewId.trim();
            UrlMapping needle = new UrlMapping();
            needle.setViewId(viewId);
            if (viewId.startsWith("/")) {
                if (this.getMappings().contains(needle)) {
                    return true;
                }
                needle.setViewId(viewId.substring(1));
            }
            return this.getMappings().contains(needle);
        }
        return false;
    }

    public UrlMapping getMappingById(String id) {
        if (id != null) {
            if (id.startsWith("pretty:")) {
                id = id.substring("pretty:".length());
            }
            for (UrlMapping mapping : this.getMappings()) {
                if (!mapping.getId().equals(id)) continue;
                return mapping;
            }
        }
        return null;
    }

    public String toString() {
        return "PrettyConfig [mappings=" + this.mappings + ", globalRewriteRules=" + this.globalRewriteRules + "]";
    }
}

