/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.spi.ELBeanNameResolver;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanNameResolver
implements ELBeanNameResolver {
    private static final Log log = LogFactory.getLog(SpringBeanNameResolver.class);
    private static final String WEB_APP_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";
    private static final String GET_BEAN_NAMES_METHOD = "getBeanNamesForType";
    private Method getBeanNamesMethod;
    private Object webAppContext;

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        this.webAppContext = servletContext.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
        if (this.webAppContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("WebApplicationContext not found in ServletContext. Resolver has been disabled.");
            }
            return false;
        }
        try {
            Class<?> webAppContextClass = classLoader.loadClass(WEB_APP_CONTEXT_CLASS);
            this.getBeanNamesMethod = webAppContextClass.getMethod(GET_BEAN_NAMES_METHOD, Class.class);
            if (log.isDebugEnabled()) {
                log.debug("Spring detected. Enabling Spring bean name resolving.");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("WebApplicationContext class could not be found. Resolver has been disabled.");
            }
        }
        catch (NoSuchMethodException e) {
            log.warn("Cannot find getBeanNamesByType() method.", e);
        }
        catch (SecurityException e) {
            log.warn("Unable to init resolver due to security restrictions", e);
        }
        return false;
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        try {
            String[] names = (String[])this.getBeanNamesMethod.invoke(this.webAppContext, clazz);
            if (names == null || names.length == 0) {
                if (log.isTraceEnabled()) {
                    log.trace("Spring doesn't know a name for class: " + clazz.getName());
                }
                return null;
            }
            if (names.length > 1) {
                log.warn("Spring returns more than one name for " + clazz.getName() + ". You should place a @URLBeanName annotation on the class.");
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace("Spring returned the name " + names[0] + " for class: " + clazz.getName());
            }
            return names[0];
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to call Spring due to security restrictions", e);
        }
        catch (InvocationTargetException e) {
            log.error("Failed to query Spring for the bean name...", e);
        }
        return null;
    }
}

