/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty;

import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyContext
implements Serializable {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CONFIG_FILES_ATTR = "com.ocpsoft.pretty.CONFIG_FILES";
    private static final Log log = LogFactory.getLog(PrettyContext.class);
    private static final long serialVersionUID = -4593906924975844541L;
    public static final String PRETTY_PREFIX = "pretty:";
    private static final String CONTEXT_REQUEST_KEY = "prettyContext";
    private PrettyConfig config;
    private final String contextPath;
    private final URL url;
    private final QueryString query;
    private UrlMapping currentMapping;
    private boolean dynaviewProcessed = false;
    private boolean inNavigation = false;

    protected PrettyContext(HttpServletRequest request) {
        this.contextPath = request.getContextPath();
        this.url = new URL(this.stripContextPath(request.getRequestURI()));
        String encoding = request.getCharacterEncoding() == null ? DEFAULT_ENCODING : request.getCharacterEncoding();
        this.url.setEncoding(encoding);
        this.query = QueryString.build(request.getQueryString());
        log.trace((Object)"Initialized PrettyContext");
    }

    public static PrettyContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return PrettyContext.getCurrentInstance(context);
    }

    public static PrettyContext getCurrentInstance(FacesContext context) {
        return PrettyContext.getCurrentInstance((HttpServletRequest)context.getExternalContext().getRequest());
    }

    public static PrettyContext getCurrentInstance(HttpServletRequest request) {
        PrettyContext prettyContext = (PrettyContext)request.getAttribute(CONTEXT_REQUEST_KEY);
        if (prettyContext instanceof PrettyContext) {
            log.trace((Object)"Retrieved PrettyContext from Request");
            return prettyContext;
        }
        return PrettyContext.newInstance(request);
    }

    public static boolean isInstantiated(ServletRequest request) {
        PrettyContext prettyContext = (PrettyContext)request.getAttribute(CONTEXT_REQUEST_KEY);
        return prettyContext instanceof PrettyContext;
    }

    static PrettyContext newInstance(HttpServletRequest request) {
        log.trace((Object)"PrettyContext not found in Request - building new instance");
        PrettyContext prettyContext = new PrettyContext(request);
        PrettyConfig prettyConfig = (PrettyConfig)request.getSession().getServletContext().getAttribute(CONFIG_FILES_ATTR);
        prettyContext.setConfig(prettyConfig);
        request.setAttribute(CONTEXT_REQUEST_KEY, (Object)prettyContext);
        return prettyContext;
    }

    public URL getRequestURL() {
        return this.url;
    }

    public QueryString getRequestQueryString() {
        return this.query;
    }

    public boolean isPrettyRequest() {
        return this.getCurrentMapping() != null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String stripContextPath(String uri) {
        if (uri.startsWith(this.contextPath)) {
            uri = uri.substring(this.contextPath.length());
        }
        return uri;
    }

    public PrettyConfig getConfig() {
        return this.config;
    }

    void setConfig(PrettyConfig config) {
        this.config = config;
    }

    public UrlMapping getCurrentMapping() {
        if (this.currentMapping == null) {
            this.currentMapping = this.config.getMappingForUrl(this.url);
        }
        return this.currentMapping;
    }

    public String getCurrentViewId() {
        if (this.getCurrentMapping() != null) {
            return this.currentMapping.getViewId();
        }
        return "";
    }

    public boolean isInNavigation() {
        return this.inNavigation;
    }

    public void setInNavigation(boolean value) {
        this.inNavigation = value;
    }

    public boolean shouldProcessDynaview() {
        if (this.isPrettyRequest()) {
            return this.getCurrentMapping().isDynaView() && !this.isDynaviewProcessed();
        }
        return false;
    }

    public boolean isDynaviewProcessed() {
        return this.dynaviewProcessed;
    }

    public void setDynaviewProcessed(boolean value) {
        this.dynaviewProcessed = value;
    }
}

