/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigurator;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.rewrite.Redirect;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.RewriteEngine;
import com.ocpsoft.pretty.faces.servlet.PrettyFacesWrappedRequest;
import com.ocpsoft.pretty.faces.servlet.PrettyFacesWrappedResponse;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyFilter
implements Filter {
    private static final Log log = LogFactory.getLog(PrettyFilter.class);
    private static final String REWRITE_OCCURRED_KEY = "com.ocpsoft.pretty.rewrite";
    private ServletContext servletContext;
    private String facesDynaViewId = "";

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        PrettyFacesWrappedResponse response = new PrettyFacesWrappedResponse((HttpServletResponse)resp, this.getConfig());
        try {
            log.debug((Object)("Character encoding: " + req.getCharacterEncoding()));
            this.rewrite((HttpServletRequest)req, (HttpServletResponse)resp);
            if (resp.isCommitted()) {
                log.trace((Object)"Rewrite occurred, reponse is committed - ending request.");
            } else {
                URL url = this.getRequestURL(req);
                if (this.getConfig().isURLMapped(url)) {
                    PrettyContext prettyContext = PrettyContext.newInstance((HttpServletRequest)req);
                    String viewId = prettyContext.getCurrentViewId();
                    if (!response.isCommitted()) {
                        if (prettyContext.shouldProcessDynaview()) {
                            log.trace((Object)("Forwarding mapped request [" + url.getURL() + "] to dynaviewId [" + viewId + "]"));
                            req.getRequestDispatcher(this.facesDynaViewId).forward(req, (ServletResponse)response);
                        } else {
                            List<PathParameter> params = prettyContext.getCurrentMapping().getPatternParser().parse(url);
                            QueryString query = QueryString.build(params);
                            PrettyFacesWrappedRequest request = new PrettyFacesWrappedRequest((HttpServletRequest)req, query.getParameterMap());
                            log.trace((Object)("Sending mapped request [" + url.getURL() + "] to resource [" + viewId + "]"));
                            if (url.getDecodedURL().matches(viewId)) {
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                            } else {
                                req.getRequestDispatcher(viewId).forward((ServletRequest)request, (ServletResponse)response);
                            }
                        }
                    }
                } else {
                    this.ensurePopulatedContext(req);
                    log.trace((Object)"Request is not mapped using PrettyFaces. Continue.");
                    chain.doFilter(req, (ServletResponse)response);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void rewrite(HttpServletRequest req, HttpServletResponse resp) {
        if (!this.rewriteOccurred((ServletRequest)req)) {
            RewriteEngine rewriteEngine = new RewriteEngine();
            URL url = this.getRequestURL((ServletRequest)req);
            try {
                String decodedUrl;
                String queryString = req.getQueryString();
                if (queryString != null && !"".equals(queryString)) {
                    queryString = "?" + queryString;
                } else if (queryString == null) {
                    queryString = "";
                }
                String newUrl = decodedUrl = url.getDecodedURL() + queryString;
                for (RewriteRule c : this.getConfig().getGlobalRewriteRules()) {
                    if (!c.matches(newUrl)) continue;
                    newUrl = rewriteEngine.processInbound(c, newUrl);
                    if (Redirect.CHAIN.equals((Object)c.getRedirect())) continue;
                    if (c.getUrl().isEmpty() && !decodedUrl.equals(newUrl)) {
                        String[] parts = newUrl.split("\\?", 2);
                        URL decoded = new URL(parts[0]);
                        decoded.setEncoding(url.getEncoding());
                        newUrl = parts.length == 2 ? decoded.getEncodedURL() + (parts[1] == null || "".equals(parts[1]) ? "" : "?") + parts[1] : decoded.getEncodedURL();
                        String redirectURL = resp.encodeRedirectURL(req.getContextPath() + newUrl);
                        resp.setHeader("Location", redirectURL);
                        resp.setStatus(c.getRedirect().getStatus());
                        resp.flushBuffer();
                        break;
                    }
                    if (c.getUrl().isEmpty()) continue;
                    String redirectURL = resp.encodeRedirectURL(newUrl);
                    resp.setHeader("Location", redirectURL);
                    resp.setStatus(c.getRedirect().getStatus());
                    resp.flushBuffer();
                    break;
                }
                if (!decodedUrl.equals(newUrl) && !resp.isCommitted()) {
                    req.getRequestDispatcher(newUrl).forward((ServletRequest)req, (ServletResponse)resp);
                }
            }
            catch (Exception e) {
                throw new PrettyException("Error occurred during canonicalization of request <[" + url + "]>", e);
            }
            finally {
                this.setRewriteOccurred((ServletRequest)req);
            }
        }
    }

    private void setRewriteOccurred(ServletRequest req) {
        req.setAttribute(REWRITE_OCCURRED_KEY, (Object)true);
    }

    private boolean rewriteOccurred(ServletRequest req) {
        return Boolean.TRUE.equals(req.getAttribute(REWRITE_OCCURRED_KEY));
    }

    private void ensurePopulatedContext(ServletRequest request) {
        PrettyContext.getCurrentInstance((HttpServletRequest)request);
    }

    public PrettyConfig getConfig() {
        if (this.servletContext == null) {
            log.warn((Object)"PrettyFilter is not registered in web.xml, but is registered with JSF Navigation and Action handlers -- this could cause unpredictable behavior.");
            return new PrettyConfig();
        }
        return (PrettyConfig)this.servletContext.getAttribute("com.ocpsoft.pretty.CONFIG_FILES");
    }

    private URL getRequestURL(ServletRequest request) {
        String contextPath;
        String url = ((HttpServletRequest)request).getRequestURI();
        if (url.startsWith(contextPath = ((HttpServletRequest)request).getContextPath())) {
            url = url.substring(contextPath.length());
        }
        URL result = new URL(url);
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            result.setEncoding(encoding);
        }
        return result;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info((Object)"PrettyFilter starting up...");
        this.servletContext = filterConfig.getServletContext();
        PrettyConfigurator configurator = new PrettyConfigurator(this.servletContext);
        configurator.configure();
        this.facesDynaViewId = configurator.getFacesDynaViewId();
        log.info((Object)"PrettyFilter initialized.");
    }

    public void destroy() {
    }
}

