/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.application.PrettyRedirector;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.util.FacesNavigationURLCanonicalizer;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyNavigationHandler
extends ConfigurableNavigationHandler {
    private static final Log log = LogFactory.getLog(PrettyNavigationHandler.class);
    private final ConfigurableNavigationHandler parent;
    private final PrettyRedirector pr = PrettyRedirector.getInstance();

    public PrettyNavigationHandler(ConfigurableNavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        log.debug((Object)("Navigation requested: fromAction [" + fromAction + "], outcome [" + outcome + "]"));
        if (!this.pr.redirect(context, outcome)) {
            log.debug((Object)"Not a PrettyFaces navigation string - passing control to default nav-handler");
            PrettyContext prettyContext = PrettyContext.getCurrentInstance();
            prettyContext.setInNavigation(true);
            String originalViewId = context.getViewRoot().getViewId();
            this.parent.handleNavigation(context, fromAction, outcome);
            String newViewId = context.getViewRoot().getViewId();
            if (context.getResponseComplete() || originalViewId.equals(newViewId)) {
                prettyContext.setInNavigation(false);
            }
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        PrettyConfig config = prettyContext.getConfig();
        if (outcome != null && outcome.startsWith("pretty:") && config.isMappingId(outcome)) {
            String viewId = config.getMappingById(outcome).getViewId();
            String normalizedViewId = FacesNavigationURLCanonicalizer.normalizeRequestURI(context, viewId);
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, normalizedViewId);
            return navigationCase;
        }
        NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, outcome);
        return navigationCase;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.parent.getNavigationCases();
    }

    public void performNavigation(String outcome) {
        this.parent.performNavigation(outcome);
    }
}

