/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.beans.ExtractedValuesURLBuilder;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import com.ocpsoft.pretty.faces.util.URLDuplicatePathCanonicalizer;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyViewHandler
extends ViewHandler {
    protected ViewHandler parent;
    private static FacesElUtils elUtils = new FacesElUtils();
    private final ThreadLocal<Boolean> bookmarkable = new ThreadLocal();

    private boolean isBookmarkable() {
        Boolean result = this.bookmarkable.get();
        if (result == null) {
            result = false;
            this.bookmarkable.set(result);
        }
        return result;
    }

    private void setBookmarkable(boolean value) {
        this.bookmarkable.set(value);
    }

    public PrettyViewHandler(ViewHandler viewHandler) {
        this.parent = viewHandler;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.parent.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.parent.calculateRenderKitId(facesContext);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot view = this.parent.createView(context, viewId);
        return view;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot view = this.parent.restoreView(context, viewId);
        return view;
    }

    public String getActionURL(FacesContext context, String viewId) {
        String result = this.parent.getActionURL(context, viewId);
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        if (!this.isBookmarkable() && prettyContext.isPrettyRequest() && !prettyContext.isInNavigation() && viewId != null && viewId.equals(context.getViewRoot().getViewId())) {
            ExtractedValuesURLBuilder builder = new ExtractedValuesURLBuilder();
            result = context.getExternalContext().encodeActionURL(builder.build(prettyContext.getCurrentMapping()));
        }
        return result;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        this.setBookmarkable(true);
        String result = this.parent.getBookmarkableURL(context, viewId, parameters, includeViewParams);
        this.setBookmarkable(false);
        return result;
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        return this.parent.getRedirectURL(context, viewId, parameters, includeViewParams);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        return this.parent.getResourceURL(facesContext, path);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        this.parent.renderView(facesContext, viewRoot);
    }

    public void writeState(FacesContext facesContext) throws IOException {
        this.parent.writeState(facesContext);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        String canonicalViewId = new URLDuplicatePathCanonicalizer().canonicalize(rawViewId);
        return this.parent.deriveViewId(context, canonicalViewId);
    }

    public String calculateCharacterEncoding(FacesContext context) {
        return this.parent.calculateCharacterEncoding(context);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.parent.getViewDeclarationLanguage(context, viewId);
    }

    public void initView(FacesContext context) throws FacesException {
        this.parent.initView(context);
    }

    private void addPrettyViewParameters(FacesContext context, UIViewRoot view) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        if (prettyContext.isPrettyRequest()) {
            ValueExpression ve;
            UIComponent metadata = view.getFacet("javax_faces_metadata");
            if (metadata == null) {
                metadata = context.getApplication().createComponent("javax.faces.Panel");
                view.getFacets().put("javax_faces_metadata", metadata);
            }
            List children = metadata.getChildren();
            List<PathParameter> pathParameters = prettyContext.getCurrentMapping().getPatternParser().getPathParameters();
            for (PathParameter p : pathParameters) {
                UIViewParameter param = (UIViewParameter)context.getApplication().createComponent("javax.faces.ViewParameter");
                Map requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(p.getName(), p.getValue());
                param.setName(p.getName());
                ve = elUtils.createValueExpression(context, p.getExpression().getELExpression());
                param.setValueExpression("value", ve);
                param.setImmediate(true);
                children.add(param);
            }
            List<QueryParameter> queryParams = prettyContext.getCurrentMapping().getQueryParams();
            for (QueryParameter q : queryParams) {
                UIViewParameter param = new UIViewParameter();
                param.setName(q.getName());
                ve = elUtils.createValueExpression(context, q.getExpression().getELExpression());
                param.setValueExpression("value", ve);
                param.setImmediate(true);
                children.add(param);
            }
        }
    }
}

