/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URLPatternParser;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELException;
import javax.faces.context.FacesContext;

public class ExtractedValuesURLBuilder {
    private static final FacesElUtils elUtils = new FacesElUtils();

    public String build(UrlMapping mapping) {
        String result = "";
        String expression = "";
        Object value = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            PrettyContext prettyContext = PrettyContext.getCurrentInstance();
            URLPatternParser parser = new URLPatternParser(mapping.getPattern());
            List<PathParameter> parameters = parser.getPathParameters();
            ArrayList<String> parameterValues = new ArrayList<String>();
            for (PathParameter injection : parameters) {
                expression = injection.getExpression().getELExpression();
                value = elUtils.getValue(context, expression);
                if (value == null) {
                    throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Required value " + " < " + expression + " > was null");
                }
                parameterValues.add(value.toString());
            }
            List<QueryParameter> queryParams = mapping.getQueryParams();
            ArrayList<QueryParameter> queryParameterValues = new ArrayList<QueryParameter>();
            for (QueryParameter injection : queryParams) {
                String name = injection.getName();
                expression = injection.getExpression().getELExpression();
                value = elUtils.getValue(context, expression);
                if (name == null || value == null) continue;
                if (value.getClass().isArray()) {
                    Object[] values;
                    for (Object temp : values = (Object[])value) {
                        queryParameterValues.add(new QueryParameter(name, temp.toString()));
                    }
                    continue;
                }
                queryParameterValues.add(new QueryParameter(name, value.toString()));
            }
            result = prettyContext.getContextPath() + parser.getMappedURL(parameterValues).getEncodedURL() + QueryString.build(queryParameterValues);
        }
        catch (ELException e) {
            throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Error occurred while extracting values from backing bean" + " < " + expression + ":" + value + " >", e);
        }
        return result;
    }
}

