/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterInjector {
    private static final Log log = LogFactory.getLog(ParameterInjector.class);
    private static final FacesElUtils elUtils = new FacesElUtils();

    public void injectParameters(FacesContext context) {
        log.trace((Object)"Injecting parameters");
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        URL url = prettyContext.getRequestURL();
        UrlMapping mapping = prettyContext.getConfig().getMappingForUrl(url);
        if (mapping != null) {
            this.injectPathParams(context, url, mapping);
            this.injectQueryParams(context, mapping);
        }
    }

    private void injectPathParams(FacesContext context, URL url, UrlMapping mapping) {
        List<PathParameter> params = mapping.getPatternParser().parse(url);
        for (PathParameter param : params) {
            String el = param.getExpression().getELExpression();
            if (el.isEmpty()) continue;
            String value = param.getValue();
            try {
                elUtils.setValue(context, el, value);
            }
            catch (Exception e) {
                throw new PrettyException("PrettyFaces: Exception occurred while processing <" + mapping.getId() + ":" + el + "> for URL <" + url + ">", e);
            }
        }
    }

    private void injectQueryParams(FacesContext context, UrlMapping mapping) {
        List<QueryParameter> params = mapping.getQueryParams();
        for (QueryParameter param : params) {
            String el = param.getExpression().getELExpression();
            if (el.isEmpty()) continue;
            String name = param.getName();
            if (!context.getExternalContext().getRequestParameterMap().containsKey(name)) continue;
            try {
                if (elUtils.getExpectedType(context, el).isArray()) {
                    String[] values = (String[])context.getExternalContext().getRequestParameterValuesMap().get(name);
                    elUtils.setValue(context, el, values);
                    continue;
                }
                String value = (String)context.getExternalContext().getRequestParameterMap().get(name);
                elUtils.setValue(context, el, value);
            }
            catch (Exception e) {
                throw new PrettyException("PrettyFaces: Exception occurred while processing mapping<" + mapping.getId() + ":" + el + "> for query parameter named<" + name + "> " + e.getMessage(), e);
            }
        }
    }
}

