/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config;

import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.config.PrettyConfigParser;
import com.ocpsoft.pretty.faces.config.convert.CaseConverter;
import com.ocpsoft.pretty.faces.config.convert.PhaseIdConverter;
import com.ocpsoft.pretty.faces.config.convert.RedirectConverter;
import com.ocpsoft.pretty.faces.config.convert.TrailingSlashConverter;
import com.ocpsoft.pretty.faces.config.mapping.PathValidator;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlAction;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.rewrite.Case;
import com.ocpsoft.pretty.faces.config.rewrite.Redirect;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.config.rewrite.TrailingSlash;
import java.io.IOException;
import java.io.InputStream;
import javax.faces.event.PhaseId;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class DigesterPrettyConfigParser
implements PrettyConfigParser {
    private final Converter caseConverter = new CaseConverter();
    private final Converter trailingSlashConverter = new TrailingSlashConverter();
    private final Converter phaseIdConverter = new PhaseIdConverter();
    private final Converter redirectConverter = new RedirectConverter();

    public void parse(PrettyConfigBuilder builder, InputStream resource) throws IOException, SAXException {
        if (builder == null) {
            throw new IllegalArgumentException("Builder must not be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Input stream must not be null.");
        }
        Digester digester = this.configureDigester(new Digester());
        ConvertUtils.register((Converter)this.caseConverter, Case.class);
        ConvertUtils.register((Converter)this.trailingSlashConverter, TrailingSlash.class);
        ConvertUtils.register((Converter)this.phaseIdConverter, PhaseId.class);
        ConvertUtils.register((Converter)this.redirectConverter, Redirect.class);
        digester.push((Object)builder);
        digester.parse(resource);
    }

    private Digester configureDigester(Digester digester) {
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("pretty-config/rewrite", RewriteRule.class);
        digester.addSetProperties("pretty-config/rewrite");
        digester.addSetNext("pretty-config/rewrite", "addRewriteRule");
        digester.addObjectCreate("pretty-config/url-mapping", UrlMapping.class);
        digester.addSetProperties("pretty-config/url-mapping");
        digester.addCallMethod("pretty-config/url-mapping/pattern", "setPattern", 1);
        digester.addCallParam("pretty-config/url-mapping/pattern", 0, "value");
        digester.addCallMethod("pretty-config/url-mapping/pattern", "setPattern", 0);
        digester.addObjectCreate("pretty-config/url-mapping/pattern/validate", PathValidator.class);
        digester.addSetProperties("pretty-config/url-mapping/pattern/validate");
        digester.addSetNext("pretty-config/url-mapping/pattern/validate", "addPathValidator");
        digester.addObjectCreate("pretty-config/url-mapping/query-param", QueryParameter.class);
        digester.addSetProperties("pretty-config/url-mapping/query-param");
        digester.addCallMethod("pretty-config/url-mapping/query-param", "setExpression", 0);
        digester.addSetNext("pretty-config/url-mapping/query-param", "addQueryParam");
        digester.addObjectCreate("pretty-config/url-mapping/action", UrlAction.class);
        digester.addSetProperties("pretty-config/url-mapping/action");
        digester.addCallMethod("pretty-config/url-mapping/action", "setAction", 0);
        digester.addSetNext("pretty-config/url-mapping/action", "addAction");
        digester.addCallMethod("pretty-config/url-mapping/view-id", "setViewId", 0);
        digester.addSetNext("pretty-config/url-mapping", "addMapping");
        return digester;
    }
}

