/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.DynaviewEngine;
import com.ocpsoft.pretty.faces.config.DigesterPrettyConfigParser;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.config.PrettyConfigParser;
import com.ocpsoft.pretty.faces.config.annotation.AbstractClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.ClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.PackageFilter;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import com.ocpsoft.pretty.faces.config.annotation.WebClassesFinder;
import com.ocpsoft.pretty.faces.config.annotation.WebLibFinder;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.servlet.WebXmlParser;
import com.ocpsoft.pretty.faces.el.LazyBeanNameFinder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyConfigurator {
    private static final Log log = LogFactory.getLog(PrettyConfigurator.class);
    public static final String CONFIG_BASE_PACKAGES = "com.ocpsoft.pretty.BASE_PACKAGES";
    public static final String CONFIG_SCAN_LIB_DIR = "com.ocpsoft.pretty.SCAN_LIB_DIRECTORY";
    public static final String PRETTY_CONFIG_RESOURCE = "META-INF/pretty-config.xml";
    public static final String DEFAULT_PRETTY_FACES_CONFIG = "/WEB-INF/pretty-config.xml";
    private final ServletContext servletContext;
    private final PrettyConfigParser configParser = new DigesterPrettyConfigParser();
    private final WebXmlParser webXmlParser = new WebXmlParser();
    private final DynaviewEngine dynaview = new DynaviewEngine();
    private PrettyConfig config;

    public PrettyConfigurator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void configure() {
        try {
            PrettyConfigBuilder builder = new PrettyConfigBuilder();
            this.feedClassLoaderConfigs(builder);
            this.feedContextSpecifiedConfig(builder);
            this.feedWebAppConfig(builder);
            this.feedAnnotationConfigs(builder);
            this.config = builder.build();
            this.validateConfig(this.config);
            log.trace((Object)"Setting config into ServletContext");
            this.servletContext.setAttribute("com.ocpsoft.pretty.CONFIG_FILES", (Object)this.config);
        }
        catch (Exception e) {
            throw new PrettyException("Failed to load configuration.", e);
        }
    }

    private void validateConfig(PrettyConfig config) {
        for (UrlMapping m : config.getMappings()) {
            m.getPatternParser();
        }
    }

    public String getFacesDynaViewId() {
        try {
            this.webXmlParser.parse(this.servletContext);
            return this.dynaview.buildDynaViewId(this.webXmlParser.getFacesMapping());
        }
        catch (Exception e) {
            throw new PrettyException("Could not retrieve DynaViewId.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedClassLoaderConfigs(PrettyConfigBuilder builder) throws IOException, SAXException {
        Enumeration<URL> urls = this.getResourceLoader().getResources(PRETTY_CONFIG_RESOURCE);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                InputStream is = null;
                try {
                    is = this.openStream(url);
                    this.configParser.parse(builder, is);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedContextSpecifiedConfig(PrettyConfigBuilder builder) throws IOException, SAXException {
        List<String> configFilesList = this.getConfigFilesList();
        for (String systemId : configFilesList) {
            InputStream is = this.servletContext.getResourceAsStream(systemId);
            if (is == null) {
                log.error((Object)("Pretty Faces config resource [" + systemId + "] not found."));
                continue;
            }
            log.trace((Object)("Reading config [" + systemId + "]."));
            try {
                this.configParser.parse(builder, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private List<String> getConfigFilesList() {
        String configFiles = this.servletContext.getInitParameter("com.ocpsoft.pretty.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_PRETTY_FACES_CONFIG.equals(systemId)) {
                    log.warn((Object)"The file [/WEB-INF/pretty-config.xml] has been specified in the [com.ocpsoft.pretty.CONFIG_FILES] context parameter of the deployment descriptor. This will automatically be removed,  otherwise, it would be loaded twice.");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedWebAppConfig(PrettyConfigBuilder builder) throws IOException, SAXException {
        InputStream is = this.servletContext.getResourceAsStream(DEFAULT_PRETTY_FACES_CONFIG);
        if (is != null) {
            log.trace((Object)"Reading config [/WEB-INF/pretty-config.xml].");
            try {
                this.configParser.parse(builder, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void feedAnnotationConfigs(PrettyConfigBuilder builder) {
        String filterConfig = this.servletContext.getInitParameter(CONFIG_BASE_PACKAGES);
        if (filterConfig != null && filterConfig.trim().equalsIgnoreCase("none")) {
            log.debug((Object)"Annotation scanning has is disabled!");
            return;
        }
        PackageFilter packageFilter = new PackageFilter(filterConfig);
        LazyBeanNameFinder beanNameFinder = new LazyBeanNameFinder(this.servletContext);
        PrettyAnnotationHandler annotationHandler = new PrettyAnnotationHandler(beanNameFinder);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        ArrayList<AbstractClassFinder> classFinders = new ArrayList<AbstractClassFinder>();
        classFinders.add(new WebClassesFinder(this.servletContext, classloader, packageFilter));
        String jarConfig = this.servletContext.getInitParameter(CONFIG_SCAN_LIB_DIR);
        if (jarConfig != null && jarConfig.trim().equalsIgnoreCase("true")) {
            classFinders.add(new WebLibFinder(this.servletContext, classloader, packageFilter));
        }
        for (ClassFinder classFinder : classFinders) {
            classFinder.findClasses(annotationHandler);
        }
        annotationHandler.build(builder);
    }

    protected ClassLoader getResourceLoader() {
        ClassLoader resourceLoader = Thread.currentThread().getContextClassLoader();
        return resourceLoader;
    }

    protected InputStream openStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    public PrettyConfig getConfig() {
        return this.config;
    }
}

