/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import com.ocpsoft.pretty.faces.config.annotation.ByteCodeAnnotationFilter;
import com.ocpsoft.pretty.faces.config.annotation.ClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.PackageFilter;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractClassFinder
implements ClassFinder {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ServletContext servletContext;
    protected final ClassLoader classLoader;
    protected final PackageFilter packageFilter;
    private final ByteCodeAnnotationFilter byteCodeAnnotationFilter;

    public AbstractClassFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter) {
        this.servletContext = servletContext;
        this.classLoader = classLoader;
        this.packageFilter = packageFilter;
        this.byteCodeAnnotationFilter = new ByteCodeAnnotationFilter();
    }

    protected static String getWebappRelativeName(URL url, String prefix) {
        String directoryPath = url.getPath();
        int startIndex = directoryPath.lastIndexOf(prefix);
        if (startIndex == -1) {
            throw new IllegalArgumentException("Cannot find prefix '" + prefix + "' in URL: " + url.toString());
        }
        return directoryPath.substring(startIndex);
    }

    protected static String getClassName(String filename, String prefix) {
        int startIndex = 0;
        if (prefix != null && prefix.length() > 0) {
            int prefixLastIndex = filename.lastIndexOf(prefix);
            if (prefixLastIndex == -1) {
                throw new IllegalArgumentException("Cannot find prefix '" + prefix + "' in filename: " + filename);
            }
            startIndex = prefixLastIndex + prefix.length();
        }
        int endIndex = filename.length() - ".class".length();
        String relativePath = filename.substring(startIndex, endIndex);
        return relativePath.replace('/', '.');
    }

    protected boolean mustProcessClass(String className) {
        String packageName = "";
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex != -1) {
            packageName = className.substring(0, packageEndIndex);
        }
        return this.packageFilter.isAllowedPackage(packageName);
    }

    protected void processClass(String className, InputStream classFileStream, PrettyAnnotationHandler handler) {
        block8: {
            if (classFileStream != null) {
                try {
                    boolean shouldScanClass = this.byteCodeAnnotationFilter.accept(classFileStream);
                    if (!shouldScanClass) {
                        return;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Bytecode filter recommends to scan class: " + className));
                    }
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)("Failed to parse class file: " + className), (Throwable)e);
                }
            }
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            handler.processClass(clazz);
        }
        catch (NoClassDefFoundError e) {
            this.log.debug((Object)("Could not load class '" + className + "': " + e.toString()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load class: " + className, e);
        }
    }
}

