/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackageFilter {
    private static final Log log = LogFactory.getLog(PackageFilter.class);
    private final Set<String> packageSet = new HashSet<String>();

    public PackageFilter(String config) {
        String[] names;
        if (config == null || config.trim().length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No package filter specified!");
            }
            return;
        }
        for (String name : names = config.split(",")) {
            if (name.trim().length() <= 0) continue;
            this.packageSet.add(name.trim());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of packages in filter: " + this.packageSet.size()));
        }
    }

    public boolean isAllowedPackage(String packageName) {
        if (this.packageSet.isEmpty()) {
            return true;
        }
        for (String validPackage : this.packageSet) {
            if (!packageName.startsWith(validPackage)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfBasePackages() {
        return this.packageSet.size();
    }
}

