/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import com.ocpsoft.pretty.faces.config.annotation.AbstractClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.PackageFilter;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;

public class WebClassesFinder
extends AbstractClassFinder {
    private static final String CLASSES_FOLDER = "/WEB-INF/classes/";

    public WebClassesFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter) {
        super(servletContext, classLoader, packageFilter);
    }

    public void findClasses(PrettyAnnotationHandler handler) {
        try {
            URL classesFolderUrl = this.servletContext.getResource(CLASSES_FOLDER);
            if (classesFolderUrl == null) {
                this.log.warn((Object)"Cannot find classes folder: /WEB-INF/classes/");
                return;
            }
            this.processDirectory(classesFolderUrl, handler);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDirectory(URL directoryUrl, PrettyAnnotationHandler handler) throws MalformedURLException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing directory: " + directoryUrl.toString()));
        }
        String relativeName = WebClassesFinder.getWebappRelativeName(directoryUrl, CLASSES_FOLDER);
        Set paths = this.servletContext.getResourcePaths(relativeName);
        for (Object relativePath : paths) {
            String className;
            URL entryUrl = this.servletContext.getResource(relativePath.toString());
            if (entryUrl.getPath().endsWith(".class") && this.mustProcessClass(className = WebClassesFinder.getClassName(entryUrl.toString(), CLASSES_FOLDER))) {
                InputStream classFileStream = null;
                try {
                    block13: {
                        try {
                            classFileStream = entryUrl.openStream();
                        }
                        catch (IOException e) {
                            if (!this.log.isDebugEnabled()) break block13;
                            this.log.debug((Object)("Cound not obtain InputStream for class file: " + entryUrl.toString()), (Throwable)e);
                        }
                    }
                    this.processClass(className, classFileStream, handler);
                }
                finally {
                    block15: {
                        try {
                            if (classFileStream != null) {
                                classFileStream.close();
                            }
                        }
                        catch (IOException e) {
                            if (!this.log.isDebugEnabled()) break block15;
                            this.log.debug((Object)("Failed to close input stream: " + e.getMessage()));
                        }
                    }
                }
            }
            if (!entryUrl.getPath().endsWith("/")) continue;
            this.processDirectory(entryUrl, handler);
        }
    }
}

