/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.annotation;

import com.ocpsoft.pretty.faces.config.annotation.AbstractClassFinder;
import com.ocpsoft.pretty.faces.config.annotation.PackageFilter;
import com.ocpsoft.pretty.faces.config.annotation.PrettyAnnotationHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;

public class WebLibFinder
extends AbstractClassFinder {
    private static final String LIB_FOLDER = "/WEB-INF/lib/";

    public WebLibFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter) {
        super(servletContext, classLoader, packageFilter);
    }

    public void findClasses(PrettyAnnotationHandler classHandler) {
        try {
            URL libFolderUrl = this.servletContext.getResource(LIB_FOLDER);
            if (libFolderUrl == null) {
                this.log.warn((Object)"Cannot find /WEB-INF/lib/ folder!");
                return;
            }
            String relativeName = WebLibFinder.getWebappRelativeName(libFolderUrl, LIB_FOLDER);
            Set paths = this.servletContext.getResourcePaths(relativeName);
            for (Object relativePath : paths) {
                URL entryUrl = this.servletContext.getResource(relativePath.toString());
                if (!entryUrl.getPath().endsWith(".jar")) continue;
                this.processJarFile(entryUrl, classHandler);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarFile(URL jarUrl, PrettyAnnotationHandler classHandler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing JAR file: " + jarUrl.toString()));
        }
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(jarUrl.openStream());
            JarEntry jarEntry = null;
            while ((jarEntry = jarStream.getNextJarEntry()) != null) {
                String className;
                if (!jarEntry.getName().endsWith(".class") || !this.mustProcessClass(className = WebLibFinder.getClassName(jarEntry.getName(), null))) continue;
                this.processClass(className, jarStream, classHandler);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to read JAR file: " + jarUrl.toString()), (Throwable)e);
        }
        finally {
            if (jarStream != null) {
                try {
                    jarStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

