/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.servlet;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.servlet.ServletDefinition;
import com.ocpsoft.pretty.faces.config.servlet.ServletMapping;
import com.ocpsoft.pretty.faces.config.servlet.WebXml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class WebXmlParser {
    private static final Log log = LogFactory.getLog(WebXmlParser.class);
    private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    String facesMapping = null;

    public void parse(ServletContext context) throws IOException, SAXException {
        if (context.getMajorVersion() >= 3) {
            Map servlets = context.getServletRegistrations();
            for (ServletRegistration s : servlets.values()) {
                Collection mappings;
                if (!s.getClassName().equalsIgnoreCase(FACES_SERVLET) || (mappings = s.getMappings()).isEmpty()) continue;
                this.facesMapping = (String)mappings.iterator().next();
                break;
            }
        } else {
            InputStream in = context.getResourceAsStream(WEB_XML_PATH);
            if (in == null) {
                throw new PrettyException("No web.xml found - cannot load configuration.");
            }
            WebXml webXml = new WebXml();
            if (in != null) {
                Digester digester = this.getConfiguredDigester();
                digester.push((Object)webXml);
                digester.parse(in);
                this.processConfig(webXml);
            }
        }
        log.trace((Object)"Completed parsing web.xml");
    }

    private void processConfig(WebXml webXml) {
        ServletDefinition facesServlet = null;
        if (webXml != null) {
            Iterator<ServletDefinition> si = webXml.getServlets().iterator();
            while (facesServlet == null && si.hasNext()) {
                ServletDefinition servlet = si.next();
                if (!FACES_SERVLET.equals(servlet.getServletClass())) continue;
                facesServlet = servlet;
                Iterator<ServletMapping> mi = webXml.getServletMappings().iterator();
                while (this.facesMapping == null && mi.hasNext()) {
                    ServletMapping mapping = mi.next();
                    if (!facesServlet.getServletName().equals(mapping.getServletName())) continue;
                    this.facesMapping = mapping.getUrlPattern().trim();
                }
            }
        }
    }

    private Digester getConfiguredDigester() {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("web-app/servlet", ServletDefinition.class);
        digester.addCallMethod("web-app/servlet/servlet-name", "setServletName", 0);
        digester.addCallMethod("web-app/servlet/servlet-class", "setServletClass", 0);
        digester.addSetNext("web-app/servlet", "addServlet");
        digester.addObjectCreate("web-app/servlet-mapping", ServletMapping.class);
        digester.addCallMethod("web-app/servlet-mapping/servlet-name", "setServletName", 0);
        digester.addCallMethod("web-app/servlet-mapping/url-pattern", "setUrlPattern", 0);
        digester.addSetNext("web-app/servlet-mapping", "addServletMapping");
        return digester;
    }

    public boolean isFacesPresent() {
        return this.facesMapping != null;
    }

    public String getFacesMapping() {
        if (this.isFacesPresent()) {
            return this.facesMapping;
        }
        return "";
    }
}

