/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el;

import com.ocpsoft.pretty.faces.el.BeanNameResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBeanNameFinder {
    private static final Log log = LogFactory.getLog(LazyBeanNameFinder.class);
    private List<BeanNameResolver> resolvers = new ArrayList<BeanNameResolver>();

    public LazyBeanNameFinder(ServletContext servletContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        for (BeanNameResolver resolver : ServiceLoader.load(BeanNameResolver.class)) {
            boolean initialized;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Initializing BeanNameResolver: " + resolver.getClass().getName()));
            }
            if (!(initialized = resolver.init(servletContext, classLoader))) continue;
            this.resolvers.add(resolver);
        }
    }

    public String findBeanName(Class<?> clazz) throws IllegalStateException {
        for (BeanNameResolver resolver : this.resolvers) {
            String name = resolver.getBeanName(clazz);
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("Cannot find name of bean '" + clazz.getName() + "'! You should place a @URLBeanName annotation on this class to let PrettyFaces know its name.");
    }
}

