/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.el.BeanNameResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIBeanNameResolver
implements BeanNameResolver {
    private static final Log log = LogFactory.getLog(CDIBeanNameResolver.class);
    public static final String BEAN_MANAGER_JNDI = "java:comp/BeanManager";
    public static final String BEAN_MANAGER_CLASS = "javax.enterprise.inject.spi.BeanManager";
    public static final String GET_BEANS_METHOD = "getBeans";
    private static final String BEAN_CLASS = "javax.enterprise.inject.spi.Bean";
    public static final String GET_NAME_METHOD = "getName";
    private Method getBeansMethod = null;
    private Method getNameMethod = null;
    private Object beanManager;

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        try {
            Class<?> beanManagerClass = classLoader.loadClass(BEAN_MANAGER_CLASS);
            this.getBeansMethod = beanManagerClass.getMethod(GET_BEANS_METHOD, Type.class, Annotation[].class);
            Class<?> beanClass = classLoader.loadClass(BEAN_CLASS);
            this.getNameMethod = beanClass.getMethod(GET_NAME_METHOD, new Class[0]);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"BeanManager or Bean class not found. CDI resolver has been disabled.");
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)"Cannot find BeanManager.getBeans() or Bean.getName() method", (Throwable)e);
            return false;
        }
        catch (SecurityException e) {
            log.warn((Object)"Unable to init resolver due to security restrictions", (Throwable)e);
            return false;
        }
        this.beanManager = this.getBeanManagerFromServletContext(servletContext);
        if (this.beanManager == null) {
            this.beanManager = this.getBeanManagerFromJNDI();
        }
        if (this.beanManager == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"BeanManager cannot be found! CDI resolver gets disabled!");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"CDI environment detected. Enabling bean name resolving via BeanManager.");
        }
        return true;
    }

    private Object getBeanManagerFromServletContext(ServletContext servletContext) {
        Object obj = servletContext.getAttribute(BEAN_MANAGER_CLASS);
        if (log.isTraceEnabled()) {
            if (obj == null) {
                log.trace((Object)"BeanManager not found in servlet context.");
            } else {
                log.trace((Object)"Found BeanManager in the servlet context.");
            }
        }
        return obj;
    }

    private Object getBeanManagerFromJNDI() {
        try {
            InitialContext initialContext = new InitialContext();
            Object obj = initialContext.lookup(BEAN_MANAGER_JNDI);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Found BeanManager in JNDI!");
            }
            return obj;
        }
        catch (NamingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to get BeanManager from JNDI: " + e.getMessage()));
            }
            return null;
        }
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        try {
            Set beansSet = (Set)this.getBeansMethod.invoke(this.beanManager, clazz, Array.newInstance(Annotation.class, 0));
            if (beansSet == null || beansSet.size() == 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("BeanManager doesn't know  class: " + clazz.getName()));
                }
                return null;
            }
            if (beansSet.size() > 1) {
                log.warn((Object)("The BeanManager returns more than one name for " + clazz.getName() + ". You should place a @URLBeanName annotation on the class."));
                return null;
            }
            Object bean = beansSet.iterator().next();
            String name = (String)this.getNameMethod.invoke(bean, new Object[0]);
            if (log.isTraceEnabled()) {
                log.trace((Object)("BeanManager returned name " + name + " for class: " + clazz.getName()));
            }
            return name;
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Unable to access BeanManager due to security restrictions", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Failed to query BeanManager for the bean name...", (Throwable)e);
        }
        return null;
    }
}

