/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.el.BeanNameResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigBeanNameResolver
implements BeanNameResolver {
    private static final Log log = LogFactory.getLog(FacesConfigBeanNameResolver.class);
    private static final String WEB_INF_FACES_CONFIG_XML = "/WEB-INF/faces-config.xml";
    private static final String META_INF_FACES_CONFIG_XML = "META-INF/faces-config.xml";
    private Map<String, String> beanNameMap = new HashMap<String, String>();

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        ArrayList<FacesConfigEntry> facesConfigEntries = new ArrayList<FacesConfigEntry>();
        Set<URI> facesConfigs = this.getFacesConfigFiles(servletContext, classLoader);
        for (URI uri : facesConfigs) {
            this.processFacesConfig(uri, facesConfigEntries);
        }
        for (FacesConfigEntry entry : facesConfigEntries) {
            this.beanNameMap.put(entry.getBeanClass(), entry.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + this.beanNameMap.size() + " bean names in faces configuration."));
        }
        return true;
    }

    private Set<URI> getFacesConfigFiles(ServletContext servletContext, ClassLoader classLoader) {
        HashSet<URI> result = new HashSet<URI>();
        try {
            URL defaultFacesConfig = servletContext.getResource(WEB_INF_FACES_CONFIG_XML);
            if (defaultFacesConfig != null) {
                result.add(defaultFacesConfig.toURI());
            }
            result.addAll(this.getConfigFilesFromInitParameter(servletContext));
            try {
                Enumeration<URL> resources = classLoader.getResources(META_INF_FACES_CONFIG_XML);
                while (resources.hasMoreElements()) {
                    result.add(resources.nextElement().toURI());
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to load faces-config.xml files from META-INF directories", (Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private Collection<URI> getConfigFilesFromInitParameter(ServletContext servletContext) {
        String initParam = servletContext.getInitParameter("javax.faces.CONFIG_FILES");
        if (initParam == null || initParam.trim().length() == 0) {
            return Collections.emptySet();
        }
        String[] files = initParam.split(",");
        HashSet<URI> result = new HashSet<URI>();
        for (String file : files) {
            if (file.trim().length() == 0) continue;
            try {
                URL url = servletContext.getResource(file.trim());
                if (url == null) continue;
                result.add(url.toURI());
            }
            catch (MalformedURLException e) {
                log.debug((Object)("Invalid entry in javax.faces.CONFIG_FILES init parameter: " + file));
            }
            catch (URISyntaxException e) {
                log.warn((Object)"Unable to create URI from URL", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFacesConfig(URI uri, List<FacesConfigEntry> facesConfigEntries) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Loading bean names from: " + uri.toString()));
        }
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        digester.setEntityResolver((EntityResolver)new EmptyEntityResolver());
        digester.push(facesConfigEntries);
        digester.addObjectCreate("faces-config/managed-bean", FacesConfigEntry.class);
        digester.addCallMethod("faces-config/managed-bean/managed-bean-name", "setName", 0);
        digester.addCallMethod("faces-config/managed-bean/managed-bean-class", "setBeanClass", 0);
        digester.addSetNext("faces-config/managed-bean", "add");
        InputStream stream = null;
        try {
            stream = uri.toURL().openStream();
            digester.parse(stream);
        }
        catch (IOException e) {
            log.error((Object)("Failed to parse: " + uri.toString()), (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)("Failed to parse: " + uri.toString()), (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        String name = this.beanNameMap.get(clazz.getName());
        if (name != null) {
            return name;
        }
        return null;
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        private EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    public static class FacesConfigEntry {
        private String name;
        private String beanClass;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBeanClass() {
            return this.beanClass;
        }

        public void setBeanClass(String beanClass) {
            this.beanClass = beanClass;
        }
    }
}

