/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.el.BeanNameResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanNameResolver
implements BeanNameResolver {
    private static final Log log = LogFactory.getLog(SpringBeanNameResolver.class);
    private static final String WEB_APP_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";
    private static final String GET_BEAN_NAMES_METHOD = "getBeanNamesForType";
    private Method getBeanNamesMethod;
    private Object webAppContext;

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        this.webAppContext = servletContext.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
        if (this.webAppContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"WebApplicationContext not found in ServletContext. Resolver has been disabled.");
            }
            return false;
        }
        try {
            Class<?> webAppContextClass = classLoader.loadClass(WEB_APP_CONTEXT_CLASS);
            this.getBeanNamesMethod = webAppContextClass.getMethod(GET_BEAN_NAMES_METHOD, Class.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Spring detected. Enabling Spring bean name resolving.");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"WebApplicationContext class could not be found. Resolver has been disabled.");
            }
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)"Cannot find getBeanNamesByType() method.", (Throwable)e);
        }
        catch (SecurityException e) {
            log.warn((Object)"Unable to init resolver due to security restrictions", (Throwable)e);
        }
        return false;
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        try {
            String[] names = (String[])this.getBeanNamesMethod.invoke(this.webAppContext, clazz);
            if (names == null || names.length == 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Spring doesn't know a name for class: " + clazz.getName()));
                }
                return null;
            }
            if (names.length > 1) {
                log.warn((Object)("Spring returns more than one name for " + clazz.getName() + ". You should place a @URLBeanName annotation on the class."));
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring returned the name " + names[0] + " for class: " + clazz.getName()));
            }
            return names[0];
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Unable to call Spring due to security restrictions", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Failed to query Spring for the bean name...", (Throwable)e);
        }
        return null;
    }
}

