/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.event;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.application.PrettyRedirector;
import com.ocpsoft.pretty.faces.beans.ActionExecutor;
import com.ocpsoft.pretty.faces.beans.ExtractedValuesURLBuilder;
import com.ocpsoft.pretty.faces.beans.ParameterInjector;
import com.ocpsoft.pretty.faces.beans.ParameterValidator;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import com.ocpsoft.pretty.faces.util.FacesMessagesUtils;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 2345410822999587673L;
    private static final Log log = LogFactory.getLog(PrettyPhaseListener.class);
    private static FacesElUtils elUtils = new FacesElUtils();
    private final FacesMessagesUtils messagesUtils = new FacesMessagesUtils();
    private final ActionExecutor executor = new ActionExecutor();
    private final ParameterInjector injector = new ParameterInjector();
    private final ParameterValidator validator = new ParameterValidator();

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            PrettyContext prettyContext = PrettyContext.getCurrentInstance();
            if (prettyContext.shouldProcessDynaview()) {
                UIViewRoot viewRoot = facesContext.getViewRoot();
                if (viewRoot == null) {
                    viewRoot = new UIViewRoot();
                    viewRoot.setViewId("/com.ocpsoft.Dynaview.xhtml");
                    facesContext.setViewRoot(viewRoot);
                }
                facesContext.responseComplete();
            }
        } else if (!facesContext.getResponseComplete()) {
            FacesContext context = facesContext;
            this.messagesUtils.restoreMessages(context, context.getExternalContext().getRequestMap());
            this.processEvent(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            this.validator.validateParameters(event.getFacesContext());
            this.injector.injectParameters(event.getFacesContext());
            if (prettyContext.shouldProcessDynaview()) {
                this.processDynaView(prettyContext, event.getFacesContext());
            } else if (!event.getFacesContext().getResponseComplete()) {
                FacesContext context = event.getFacesContext();
                this.messagesUtils.restoreMessages(context, context.getExternalContext().getRequestMap());
                this.processEvent(event);
            }
        }
    }

    private void processDynaView(PrettyContext prettyContext, FacesContext facesContext) {
        log.trace((Object)("Requesting DynaView processing for: " + prettyContext.getRequestURL().getDecodedURL()));
        String viewId = "";
        try {
            viewId = prettyContext.getCurrentViewId();
            log.trace((Object)("Invoking DynaView method: " + viewId));
            String result = this.computeDynaViewId();
            if (result instanceof String) {
                viewId = result;
                log.trace((Object)("Forwarding to DynaView: " + viewId));
                prettyContext.setDynaviewProcessed(true);
                facesContext.getExternalContext().dispatch(viewId);
                facesContext.responseComplete();
            }
        }
        catch (Exception e) {
            PrettyRedirector prettyRedirector = new PrettyRedirector();
            prettyRedirector.send404(facesContext);
            throw new PrettyException("Could not forward to view: " + viewId + "", e);
        }
    }

    private String computeDynaViewId() {
        String result = "";
        PrettyContext context = PrettyContext.getCurrentInstance();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UrlMapping urlMapping = context.getCurrentMapping();
        if (urlMapping != null) {
            String viewId = urlMapping.getViewId();
            if (viewId == null) {
                viewId = "";
            }
            while (elUtils.isEl(viewId)) {
                Object viewResult = elUtils.invokeMethod(facesContext, viewId);
                if (viewResult == null) {
                    viewId = "";
                    break;
                }
                viewId = viewResult.toString();
                if (context.getConfig().isMappingId(viewId)) {
                    urlMapping = context.getConfig().getMappingById(viewId);
                    viewId = urlMapping.getViewId();
                    result = new ExtractedValuesURLBuilder().build(urlMapping);
                    continue;
                }
                result = viewId;
            }
            if ("".equals(viewId)) {
                log.debug((Object)("ViewId for mapping with id <" + urlMapping.getId() + "> was blank"));
            }
        }
        return context.stripContextPath(result);
    }

    private void processEvent(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        UrlMapping mapping = prettyContext.getCurrentMapping();
        if (mapping != null) {
            this.executor.executeActions(context, event.getPhaseId(), mapping);
        }
    }
}

