/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.servlet;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.RewriteEngine;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.util.PrettyURLBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PrettyFacesWrappedResponse
extends HttpServletResponseWrapper {
    private final RewriteEngine rewriteEngine = new RewriteEngine();

    public PrettyFacesWrappedResponse(HttpServletResponse response, PrettyConfig config) {
        super(response);
    }

    public String encodeRedirectUrl(String url) {
        return super.encodeRedirectUrl(url);
    }

    public String encodeRedirectURL(String url) {
        return super.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return super.encodeUrl(url);
    }

    public String encodeURL(String url) {
        FacesContext context = FacesContext.getCurrentInstance();
        PrettyContext prettyContext = PrettyContext.getCurrentInstance();
        String result = this.rewritePrettyMappings(url, context, prettyContext);
        result = this.rewrite(result, prettyContext);
        return super.encodeURL(result);
    }

    private String rewritePrettyMappings(String url, FacesContext context, PrettyContext prettyContext) {
        String contextPath = "";
        String result = url;
        if (url != null && context != null && !context.getResponseComplete()) {
            String strippedUrl = prettyContext.stripContextPath(url);
            if (!url.equals(strippedUrl)) {
                contextPath = prettyContext.getContextPath();
            }
            ArrayList<UrlMapping> matches = new ArrayList<UrlMapping>();
            for (UrlMapping m : prettyContext.getConfig().getMappings()) {
                if ("".equals(m.getViewId()) || !strippedUrl.startsWith(m.getViewId())) continue;
                matches.add(m);
            }
            Collections.sort(matches, UrlMapping.ORDINAL_COMPARATOR);
            for (UrlMapping m : matches) {
                UIParameter uip;
                if (!m.isOutbound()) continue;
                ArrayList<UIParameter> uiParams = new ArrayList<UIParameter>();
                QueryString qs = QueryString.build("");
                if (url.contains("?")) {
                    qs.addParameters(url);
                }
                Map<String, String[]> queryParams = qs.getParameterMap();
                List<PathParameter> pathParams = m.getPatternParser().getPathParameters();
                int pathParamsFound = 0;
                for (PathParameter pathParameter : pathParams) {
                    uip = new UIParameter();
                    String[] values = queryParams.get(pathParameter.getName());
                    if (values != null && values.length > 0) {
                        String value = values[0];
                        uip.setValue((Object)value);
                        if (value != null && !"".equals(value)) {
                            ++pathParamsFound;
                        }
                    }
                    queryParams.remove(pathParameter.getName());
                    uiParams.add(uip);
                }
                for (Map.Entry entry : queryParams.entrySet()) {
                    uip = new UIParameter();
                    uip.setName((String)entry.getKey());
                    uip.setValue(entry.getValue());
                    uiParams.add(uip);
                }
                if (pathParams.size() != pathParamsFound) continue;
                PrettyURLBuilder builder = new PrettyURLBuilder();
                result = contextPath + builder.build(m, uiParams);
                break;
            }
        }
        return result;
    }

    private String rewrite(String url, PrettyContext context) {
        String result = "";
        if (url != null) {
            String strippedUrl = context.stripContextPath(url);
            if (!strippedUrl.equals(url)) {
                result = PrettyContext.getCurrentInstance().getContextPath();
            }
            try {
                for (RewriteRule c : context.getConfig().getGlobalRewriteRules()) {
                    strippedUrl = this.rewriteEngine.processOutbound(c, strippedUrl);
                }
                result = result + strippedUrl;
            }
            catch (Exception e) {
                throw new PrettyException("Error occurred during canonicalization of request <[" + url + "]>", e);
            }
        }
        return result;
    }
}

