/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata {
    private String encoding = "UTF-8";
    private boolean trailingSlash = false;
    private boolean leadingSlash = false;

    public Metadata copy() {
        Metadata result = new Metadata();
        result.setEncoding(this.encoding);
        result.setTrailingSlash(this.trailingSlash);
        result.setLeadingSlash(this.leadingSlash);
        return result;
    }

    public String buildURLFromSegments(List<String> segments) {
        StringBuilder result = new StringBuilder("/");
        Iterator<String> iter = segments.iterator();
        while (iter.hasNext()) {
            String segment = iter.next();
            result.append(segment);
            if (!iter.hasNext()) continue;
            result.append("/");
        }
        if (this.hasTrailingSlash() && !result.toString().endsWith("/")) {
            result.append("/");
        }
        return result.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean hasTrailingSlash() {
        return this.trailingSlash;
    }

    public void setTrailingSlash(boolean trailingSlash) {
        this.trailingSlash = trailingSlash;
    }

    public boolean hasLeadingSlash() {
        return this.leadingSlash;
    }

    public void setLeadingSlash(boolean leadingSlash) {
        this.leadingSlash = leadingSlash;
    }
}

