/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.url.Metadata;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL {
    private Metadata metadata = new Metadata();
    private String originalURL = "";
    private List<String> segments;
    private final Map<String, String> encodedURLs = new HashMap<String, String>();
    private final Map<String, String> decodedURLs = new HashMap<String, String>();
    private final Map<String, List<String>> decodedSegments = new HashMap<String, List<String>>();

    public URL(String url) {
        if (url != null) {
            this.originalURL = url.trim();
            if (this.originalURL.endsWith("/")) {
                this.metadata.setTrailingSlash(true);
            }
            if (this.originalURL.startsWith("/")) {
                this.metadata.setLeadingSlash(true);
            }
        } else {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        String trimmedUrl = this.trimSurroundingSlashes(url);
        String[] segments = trimmedUrl.split("/");
        this.segments = Arrays.asList(segments);
    }

    public URL(List<String> segments, Metadata metadata) {
        this.metadata = metadata;
        this.segments = segments;
        this.originalURL = metadata.buildURLFromSegments(segments);
    }

    public String getDecodedURL() {
        String encoding = this.metadata.getEncoding();
        if (!this.decodedURLs.containsKey(encoding)) {
            ArrayList<String> resultSegments = new ArrayList<String>();
            for (String segment : this.segments) {
                try {
                    String encoded = URLDecoder.decode(segment, encoding);
                    resultSegments.add(encoded);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PrettyException("Could not decode URL with specified format: " + encoding, e);
                }
            }
            String result = this.metadata.buildURLFromSegments(resultSegments);
            this.decodedURLs.put(encoding, result);
        }
        return this.decodedURLs.get(encoding);
    }

    public String getEncodedURL() {
        String encoding = this.metadata.getEncoding();
        if (!this.encodedURLs.containsKey(encoding)) {
            ArrayList<String> resultSegments = new ArrayList<String>();
            for (String segment : this.segments) {
                try {
                    String encoded = URLEncoder.encode(segment, encoding);
                    resultSegments.add(encoded);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PrettyException("Could not encode URL with specified format: " + encoding, e);
                }
            }
            String result = this.metadata.buildURLFromSegments(resultSegments);
            this.encodedURLs.put(encoding, result);
        }
        return this.encodedURLs.get(encoding);
    }

    public List<String> getDecodedSegments() {
        String encoding = this.metadata.getEncoding();
        if (!this.decodedSegments.containsKey(encoding)) {
            ArrayList<String> result = new ArrayList<String>();
            for (String segment : this.segments) {
                try {
                    String decoded = URLDecoder.decode(segment, encoding);
                    result.add(decoded);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PrettyException("Could not decode URL with specified format: " + encoding, e);
                }
            }
            this.decodedSegments.put(encoding, Collections.unmodifiableList(result));
        }
        return this.decodedSegments.get(encoding);
    }

    private String trimSurroundingSlashes(String url) {
        String result = null;
        if (url != null) {
            result = url.trim();
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public int numSegments() {
        return this.segments.size();
    }

    public String toString() {
        return this.getURL();
    }

    public String getURL() {
        return this.originalURL;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public boolean hasLeadingSlash() {
        return this.metadata.hasLeadingSlash();
    }

    public boolean hasTrailingSlash() {
        return this.metadata.hasTrailingSlash();
    }

    public String getEncoding() {
        return this.metadata.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.metadata.setEncoding(encoding);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

