/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigurator;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.reload.PrettyConfigReloader;
import com.ocpsoft.pretty.faces.config.rewrite.Redirect;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.RewriteEngine;
import com.ocpsoft.pretty.faces.servlet.PrettyFacesWrappedRequest;
import com.ocpsoft.pretty.faces.servlet.PrettyFacesWrappedResponse;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.StringUtils;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrettyFilter
implements Filter {
    private static final Log log = LogFactory.getLog(PrettyFilter.class);
    private static final String REWRITE_OCCURRED_KEY = "com.ocpsoft.pretty.rewrite";
    private static final String URL_MAPPING_FORWARD_KEY = "com.ocpsoft.pretty.url_mapping_forward";
    private ServletContext servletContext;
    private PrettyConfigReloader reloader = new PrettyConfigReloader();

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (!PrettyContext.isInstantiated((ServletRequest)request)) {
            this.reloader.onNewRequest(this.servletContext);
        }
        PrettyFacesWrappedResponse response = new PrettyFacesWrappedResponse(request.getContextPath(), request, (HttpServletResponse)resp, this.getConfig());
        req.setAttribute("com.ocpsoft.pretty.CONFIG_FILES", (Object)this.getConfig());
        PrettyContext context = PrettyContext.newDetachedInstance(request);
        this.rewrite(request, (HttpServletResponse)response);
        if (resp.isCommitted()) {
            log.trace("Rewrite occurred, reponse is committed - ending request.");
        } else {
            URL url = context.getRequestURL();
            UrlMapping mapping = null;
            if (!this.isUrlMappingForward(req)) {
                mapping = this.getConfig().getMappingForUrl(url);
            }
            if (mapping != null) {
                context.setCurrentMapping(mapping);
                PrettyContext.setCurrentContext(request, context);
                String viewId = context.getCurrentViewId();
                if (!response.isCommitted()) {
                    if (context.shouldProcessDynaview()) {
                        log.trace("Forwarding mapped request [" + url.toURL() + "] to dynaviewId [" + viewId + "]");
                        this.setUrlMappingForward((ServletRequest)request);
                        req.getRequestDispatcher(context.getDynaViewId()).forward(req, (ServletResponse)response);
                    } else {
                        List<PathParameter> params = context.getCurrentMapping().getPatternParser().parse(url);
                        QueryString query = QueryString.build(params);
                        PrettyFacesWrappedRequest wrappedRequest = new PrettyFacesWrappedRequest(request, query.getParameterMap());
                        log.trace("Sending mapped request [" + url.toURL() + "] to resource [" + viewId + "]");
                        if (url.decode().toURL().equals(viewId)) {
                            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
                        } else {
                            this.setUrlMappingForward((ServletRequest)request);
                            req.getRequestDispatcher(viewId).forward((ServletRequest)wrappedRequest, (ServletResponse)response);
                        }
                    }
                }
            } else {
                log.trace("Request is not mapped using PrettyFaces. Continue.");
                chain.doFilter(req, (ServletResponse)response);
            }
        }
    }

    private void rewrite(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.rewriteOccurred((ServletRequest)req) && !this.isUrlMappingForward((ServletRequest)req)) {
            String originalUrl;
            RewriteEngine rewriteEngine = new RewriteEngine();
            URL url = PrettyContext.newDetachedInstance(req).getRequestURL();
            String queryString = req.getQueryString();
            if (queryString != null && !"".equals(queryString)) {
                queryString = "?" + queryString;
            } else if (queryString == null) {
                queryString = "";
            }
            String newUrl = originalUrl = url.toURL() + queryString;
            for (RewriteRule rule : this.getConfig().getGlobalRewriteRules()) {
                if (!rule.matches(newUrl)) continue;
                newUrl = rewriteEngine.processInbound(req, resp, rule, newUrl);
                if (Redirect.CHAIN.equals((Object)rule.getRedirect())) continue;
                String redirectURL = null;
                if (StringUtils.isBlank(rule.getUrl()) && !originalUrl.equals(newUrl)) {
                    redirectURL = resp.encodeRedirectURL(req.getContextPath() + newUrl);
                } else if (StringUtils.isNotBlank(rule.getUrl())) {
                    redirectURL = newUrl.trim();
                }
                if (redirectURL == null) continue;
                String encodedRedirectURL = this.encodeUrlWithQueryString(redirectURL);
                resp.setHeader("Location", encodedRedirectURL);
                resp.setStatus(rule.getRedirect().getStatus());
                resp.flushBuffer();
                break;
            }
            if (!originalUrl.equals(newUrl) && !resp.isCommitted()) {
                this.setRewriteOccurred((ServletRequest)req);
                req.getRequestDispatcher(newUrl).forward((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    private String encodeUrlWithQueryString(String url) {
        try {
            String[] urlParts = url.split("\\?", 2);
            String baseUrlEncoded = new URI(urlParts[0]).toASCIIString();
            if (urlParts.length > 1 && StringUtils.isNotBlank(urlParts[1])) {
                return baseUrlEncoded + QueryString.build(urlParts[1]).toQueryString();
            }
            return baseUrlEncoded;
        }
        catch (URISyntaxException e) {
            log.warn("Failed to encode URL '" + url + "': " + e.getMessage());
            return url;
        }
    }

    private void setRewriteOccurred(ServletRequest req) {
        req.setAttribute(REWRITE_OCCURRED_KEY, (Object)true);
    }

    private boolean rewriteOccurred(ServletRequest req) {
        return Boolean.TRUE.equals(req.getAttribute(REWRITE_OCCURRED_KEY));
    }

    private void setUrlMappingForward(ServletRequest req) {
        req.setAttribute(URL_MAPPING_FORWARD_KEY, (Object)true);
    }

    private boolean isUrlMappingForward(ServletRequest req) {
        return Boolean.TRUE.equals(req.getAttribute(URL_MAPPING_FORWARD_KEY));
    }

    public PrettyConfig getConfig() {
        if (this.servletContext == null || this.servletContext.getAttribute("com.ocpsoft.pretty.CONFIG_FILES") == null) {
            log.warn("PrettyFilter is not registered in web.xml, but is registered with JSF Navigation and Action handlers -- this could cause unpredictable behavior.");
            return new PrettyConfig();
        }
        return (PrettyConfig)this.servletContext.getAttribute("com.ocpsoft.pretty.CONFIG_FILES");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("PrettyFilter starting up...");
        this.servletContext = filterConfig.getServletContext();
        PrettyConfigurator configurator = new PrettyConfigurator(this.servletContext);
        configurator.configure();
        log.info("PrettyFilter initialized.");
    }

    public void destroy() {
        log.info("PrettyFilter shutting down...");
    }
}

