/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.reload;

import com.ocpsoft.pretty.faces.config.PrettyConfigurator;
import com.ocpsoft.pretty.faces.spi.DevelopmentModeDetector;
import com.ocpsoft.pretty.faces.util.ServiceLoader;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.ServletContext;

public class PrettyConfigReloader {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final long CONFIG_RELOAD_DELAY = 2000L;
    private long lastUpdate = 0L;
    private Boolean developmentMode = null;

    public void onNewRequest(ServletContext servletContext) {
        if (this.developmentMode == null) {
            this.developmentMode = this.isDevelopmentModeActive(servletContext);
            if (this.log.isDebugEnabled()) {
                if (this.developmentMode.booleanValue()) {
                    this.log.debug("PrettyFaces development mode detected! Configuration reloading will be enabled.");
                } else {
                    this.log.debug("No development mode detected. Configuration reloading gets disabled.");
                }
            }
        }
        if (this.developmentMode != null && this.developmentMode.booleanValue()) {
            long nextUpdate = this.lastUpdate + 2000L;
            if (System.currentTimeMillis() > nextUpdate) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reloading PrettyFaces configuration...");
                }
                this.lastUpdate = System.currentTimeMillis();
                PrettyConfigurator configurator = new PrettyConfigurator(servletContext);
                configurator.configure();
            }
        }
    }

    private boolean isDevelopmentModeActive(ServletContext servletContext) {
        ServiceLoader<DevelopmentModeDetector> serviceLoader = ServiceLoader.load(DevelopmentModeDetector.class);
        ArrayList<DevelopmentModeDetector> detectors = new ArrayList<DevelopmentModeDetector>();
        for (DevelopmentModeDetector detector : serviceLoader) {
            detectors.add(detector);
        }
        Collections.sort(detectors, new Comparator<DevelopmentModeDetector>(){

            @Override
            public int compare(DevelopmentModeDetector left, DevelopmentModeDetector right) {
                return left.getPriority() - right.getPriority();
            }
        });
        for (DevelopmentModeDetector detector : detectors) {
            Boolean result = detector.isDevelopmentMode(servletContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Detector " + detector.getClass().getSimpleName() + " returned: " + result);
            }
            if (result == null) continue;
            return result;
        }
        return false;
    }
}

