/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.el.ConstantExpression;
import com.ocpsoft.pretty.faces.el.processor.Injected;
import com.ocpsoft.pretty.faces.el.processor.Named;
import com.ocpsoft.pretty.faces.el.processor.NamedInjected;
import com.ocpsoft.pretty.faces.el.processor.PathParameterProcessor;
import com.ocpsoft.pretty.faces.el.processor.PlainText;
import com.ocpsoft.pretty.faces.el.processor.RegexOverride;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ExpressionProcessorRunner {
    public static final List<PathParameterProcessor> processors;
    public static final List<PathParameterProcessor> preProcessors;

    public static PathParameter process(String expression) {
        PathParameter result = new PathParameter();
        result.setExpression(new ConstantExpression(expression));
        for (PathParameterProcessor p : preProcessors) {
            result = p.process(result);
        }
        for (PathParameterProcessor p : processors) {
            result = p.process(result);
        }
        if (result == null) {
            throw new PrettyException("Malformed EL expression: " + expression + ", discovered.");
        }
        return result;
    }

    static {
        ArrayList<PathParameterProcessor> temp = new ArrayList<PathParameterProcessor>();
        temp.add(new Named());
        temp.add(new NamedInjected());
        temp.add(new Injected());
        temp.add(new PlainText());
        processors = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add(new RegexOverride());
        preProcessors = Collections.unmodifiableList(temp);
    }
}

