/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.el.ExpressionProcessorRunner;
import com.ocpsoft.pretty.faces.el.Expressions;
import com.ocpsoft.pretty.faces.url.Segment;
import com.ocpsoft.pretty.faces.url.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPatternParser {
    private static final Pattern EL_REGEX_PATTERN = Pattern.compile(Expressions.EL_REGEX);
    private final String originalPattern;
    private boolean elPattern;
    private URL urlPattern = null;
    private Pattern urlElPattern;
    private List<Segment> pathSegments = new ArrayList<Segment>();
    private List<PathParameter> pathParameters = new ArrayList<PathParameter>();

    public URLPatternParser(String pattern) {
        this.originalPattern = pattern;
        Matcher expressionMatcher = EL_REGEX_PATTERN.matcher(pattern);
        StringBuffer segmentableExpressions = new StringBuffer();
        this.elPattern = false;
        if (pattern.indexOf(124) != -1) {
            this.elPattern = true;
        }
        int paramIndex = 0;
        while (expressionMatcher.find()) {
            this.elPattern = true;
            String expression = expressionMatcher.group(1);
            PathParameter param = ExpressionProcessorRunner.process(expression);
            param.setPosition(paramIndex);
            this.pathParameters.add(param);
            expressionMatcher.appendReplacement(segmentableExpressions, Segment.parameterize(paramIndex));
            ++paramIndex;
        }
        expressionMatcher.appendTail(segmentableExpressions);
        this.pathParameters = Collections.unmodifiableList(this.pathParameters);
        URL segmentedPattern = new URL(segmentableExpressions.toString());
        int segmentIndex = 0;
        for (String segmentPattern : segmentedPattern.getSegments()) {
            Segment segment = new Segment();
            segment.setTemplate(segmentPattern);
            StringBuffer regex = new StringBuffer();
            Matcher parameterMatcher = Segment.getTemplateMatcher(segmentPattern);
            while (parameterMatcher.find()) {
                String group = parameterMatcher.group(1);
                PathParameter parameter = this.pathParameters.get(Integer.valueOf(group));
                segment.addParameter(parameter);
                parameterMatcher.appendReplacement(regex, "(" + parameter.getRegex() + ")");
            }
            parameterMatcher.appendTail(regex);
            segment.setRegex(regex.toString());
            this.pathSegments.add(segment);
            ++segmentIndex;
        }
        ArrayList<String> regexSegments = new ArrayList<String>();
        for (Segment s : this.pathSegments) {
            regexSegments.add(s.getRegex());
        }
        this.urlPattern = new URL(regexSegments, segmentedPattern.getMetadata().copy());
        if (this.elPattern) {
            this.urlElPattern = Pattern.compile(this.urlPattern.toURL());
        }
        this.pathSegments = Collections.unmodifiableList(this.pathSegments);
    }

    public boolean matches(URL target) {
        if (this.elPattern) {
            return this.urlElPattern.matcher(target.toURL()).matches();
        }
        return this.urlPattern.toURL().equals(target.toURL());
    }

    @Deprecated
    public boolean matches(String target) {
        URL url = new URL(target);
        return this.matches(url);
    }

    public List<PathParameter> getPathParameters() {
        return this.pathParameters;
    }

    public List<PathParameter> parse(URL url) {
        ArrayList<PathParameter> result = new ArrayList<PathParameter>();
        String inboundUrl = url.toURL();
        if (this.matches(url)) {
            Iterator<Segment> iter = this.pathSegments.iterator();
            while (iter.hasNext()) {
                Matcher segmentMatcher;
                Segment segment = iter.next();
                String regex = "";
                if (url.hasLeadingSlash() && !"/".equals(url.toURL())) {
                    regex = regex + "/";
                }
                regex = regex + segment.getRegex();
                if (iter.hasNext() || url.hasTrailingSlash()) {
                    regex = regex + "/";
                }
                if ((segmentMatcher = Pattern.compile(regex).matcher(inboundUrl)).find()) {
                    for (int j = 0; j < segment.numParameters(); ++j) {
                        String value = segmentMatcher.group(j + 1);
                        PathParameter param = segment.getParameter(j).copy();
                        param.setValue(value);
                        result.add(param);
                    }
                    int regionEnd = segmentMatcher.end();
                    inboundUrl = inboundUrl.substring(regionEnd - 1);
                    continue;
                }
                throw new PrettyException("Error parsing url: <" + url + ">, a parameter did not match compiled segment in pattern: " + this.originalPattern);
            }
        } else {
            throw new IllegalArgumentException("The given URL: " + url + ", cannot be parsed by the pattern: " + this.originalPattern);
        }
        return result;
    }

    public URL getMappedURL(Object ... params) {
        URL result = null;
        if (params != null) {
            Object[] parameters = params;
            if (params.length == 1 && params[0] != null && params[0] instanceof List) {
                List list = (List)params[0];
                parameters = list.size() == 0 ? new Object[]{} : list.toArray(params);
            } else if (params.length == 1 && params[0] == null) {
                parameters = new Object[]{};
            }
            if (this.getParameterCount() != parameters.length) {
                throw new PrettyException("Invalid number of path parameters supplied for pattern: " + this.originalPattern + ", expected <" + this.getParameterCount() + ">, but got <" + parameters.length + ">");
            }
            int paramIndex = 0;
            ArrayList<String> resultSegments = new ArrayList<String>();
            for (Segment segment : this.pathSegments) {
                String template = segment.getTemplate();
                Matcher parameterMatcher = Segment.getTemplateMatcher(template);
                StringBuffer sb = new StringBuffer();
                while (parameterMatcher.find()) {
                    String replacement = parameters[paramIndex].toString().replace("$", "\\$");
                    parameterMatcher.appendReplacement(sb, replacement);
                    ++paramIndex;
                }
                parameterMatcher.appendTail(sb);
                resultSegments.add(sb.toString());
            }
            result = new URL(resultSegments, this.urlPattern.getMetadata());
        } else if (this.getParameterCount() > 0) {
            throw new PrettyException("Invalid number of parameters supplied: " + this.originalPattern + ", expected <" + this.getParameterCount() + ">, got <0>");
        }
        return result;
    }

    public int getParameterCount() {
        return this.pathParameters.size();
    }

    public Object getPattern() {
        return this.originalPattern;
    }

    public boolean isElPattern() {
        return this.elPattern;
    }
}

