/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.bind;

import com.ocpsoft.common.services.ServiceLoader;
import com.ocpsoft.logging.Logger;
import com.ocpsoft.rewrite.bind.Binding;
import com.ocpsoft.rewrite.bind.Converter;
import com.ocpsoft.rewrite.bind.DefaultConverter;
import com.ocpsoft.rewrite.bind.DefaultValidator;
import com.ocpsoft.rewrite.bind.RetrievalBuilder;
import com.ocpsoft.rewrite.bind.SubmissionBuilder;
import com.ocpsoft.rewrite.bind.Validator;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.event.Rewrite;
import com.ocpsoft.rewrite.exception.RewriteException;
import java.lang.reflect.Array;
import java.util.Collection;

public abstract class BindingBuilder
implements Binding,
RetrievalBuilder,
SubmissionBuilder {
    private Converter<?> converter = new DefaultConverter();
    private Validator<?> validator = new DefaultValidator();
    private final Logger log = Logger.getLogger(BindingBuilder.class);

    @Override
    public BindingBuilder convertedBy(Class<? extends Converter<?>> type) {
        this.converter = this.resolveConverter(type);
        return this;
    }

    @Override
    public BindingBuilder convertedBy(Converter<?> converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public BindingBuilder validatedBy(Class<? extends Validator<?>> type) {
        this.validator = this.resolveValidator(type);
        return this;
    }

    @Override
    public BindingBuilder validatedBy(Validator<?> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public boolean validates(Rewrite event, EvaluationContext context, Object value) {
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                if (this.validator.validate(event, context, values[i])) continue;
                return false;
            }
            return true;
        }
        return this.validator.validate(event, context, value);
    }

    @Override
    public Object convert(Rewrite event, EvaluationContext context, Object value) {
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            Object[] convertedValues = new Object[values.length];
            for (int i = 0; i < convertedValues.length; ++i) {
                convertedValues[i] = this.converter.convert(event, context, values[i]);
            }
            Class type = Object.class;
            for (Object object : convertedValues) {
                if (object == null) continue;
                type = object.getClass();
                break;
            }
            Object[] result = (Object[])Array.newInstance(type, convertedValues.length);
            System.arraycopy(convertedValues, 0, result, 0, result.length);
            return result;
        }
        return this.converter.convert(event, context, value);
    }

    private Validator<?> resolveValidator(Class<? extends Validator<?>> type) {
        try {
            Collection<Validator<?>> enriched = ServiceLoader.loadEnriched(type);
            if (enriched != null) {
                if (enriched.size() > 1 && this.log.isWarnEnabled()) {
                    this.log.warn("Multiple Validator instances available for type [" + type.getName() + "], using first of " + enriched + "");
                }
                for (Validator<?> validator : enriched) {
                    if (validator == null) continue;
                    return validator;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RewriteException("Could not instantiate Validator of type [" + type.getName() + "]", e);
        }
    }

    private Converter<?> resolveConverter(Class<? extends Converter<?>> type) {
        try {
            Collection<Converter<?>> enriched = ServiceLoader.loadEnriched(type);
            if (enriched != null) {
                if (enriched.size() > 1 && this.log.isWarnEnabled()) {
                    this.log.warn("Multiple Converter instances available for type [" + type.getName() + "], using first of " + enriched + "");
                }
                for (Converter<?> converter : enriched) {
                    if (converter == null) continue;
                    return converter;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RewriteException("Could not instantiate Converter of type [" + type.getName() + "]", e);
        }
    }
}

