/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.bind.parse;

import com.ocpsoft.common.util.Assert;
import com.ocpsoft.rewrite.bind.parse.CaptureType;
import com.ocpsoft.rewrite.bind.parse.CapturingGroup;

public abstract class ParseTools {
    public static CapturingGroup balancedCapture(char[] chars, int startPos, int endPos, CaptureType type) {
        int cursor;
        Assert.notNull(chars, "Character input array must not be null.");
        Assert.assertTrue(startPos >= 0, "Start position must be greater than zero.");
        Assert.assertTrue(startPos < chars.length - 1, "Start position must be at least one character before the array upper bound.");
        Assert.assertTrue(endPos > 0, "End position must be greater than zero.");
        Assert.assertTrue(endPos < chars.length, "End position must be less than or equal to the array upper bound.");
        Assert.assertTrue(startPos < endPos, "Start position must be less than end position.");
        Assert.assertTrue(chars[startPos] == type.getBegin(), "Character at starting position was [" + chars[startPos] + "] but expected [" + type.getBegin() + "]");
        if (startPos > 0 && chars[startPos - 1] == '\\' && (startPos == 1 || startPos > 1 && chars[startPos - 2] != '\\')) {
            throw new IllegalArgumentException("Character at starting position is escaped, and cannot be used in capturing a group.");
        }
        int depth = 1;
        char begin = type.getBegin();
        char term = type.getEnd();
        for (cursor = startPos + 1; cursor < endPos && depth > 0; ++cursor) {
            if (chars[cursor] == term) {
                if (!ParseTools.isEscaped(chars, cursor)) {
                    --depth;
                }
            } else if (chars[cursor] == begin && !ParseTools.isEscaped(chars, cursor)) {
                ++depth;
            }
            if (depth == 0) break;
        }
        return new CapturingGroup(chars, startPos, cursor);
    }

    public static boolean isEscaped(char[] chars, int cursor) {
        Assert.notNull(chars, "Character input array must not be null.");
        Assert.assertTrue(cursor >= 0, "Start position must be greater than zero.");
        Assert.assertTrue(cursor < chars.length, "Start position must be within the array upper bound.");
        return cursor > 0 && chars[cursor - 1] == '\\' && (cursor == 1 || cursor > 1 && chars[cursor - 2] != '\\');
    }
}

