/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.config;

import com.ocpsoft.common.services.ServiceLoader;
import com.ocpsoft.logging.Logger;
import com.ocpsoft.rewrite.bind.Retrieval;
import com.ocpsoft.rewrite.bind.Submission;
import com.ocpsoft.rewrite.config.OperationBuilder;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.event.Rewrite;
import com.ocpsoft.rewrite.spi.InvocationResultHandler;

public class Invoke
extends OperationBuilder {
    private static final Logger log = Logger.getLogger(Invoke.class);
    private final Submission submission;
    private final Retrieval retrieval;

    private Invoke(Submission submission, Retrieval retrieval) {
        this.submission = submission;
        this.retrieval = retrieval;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        Object result = null;
        if (this.submission == null && this.retrieval != null) {
            result = this.retrieval.retrieve(event, context);
            log.debug("Invoked binding [" + this.retrieval + "] returned value [" + result + "]");
        } else if (this.retrieval != null) {
            Object converted = this.submission.convert(event, context, this.retrieval.retrieve(event, context));
            result = this.submission.submit(event, context, converted);
            log.debug("Invoked binding [" + this.submission + "] returned value [" + result + "]");
        } else {
            log.warn("No binding specified for Invocation.");
        }
        if (result != null) {
            ServiceLoader providers = ServiceLoader.load(InvocationResultHandler.class);
            if (!providers.iterator().hasNext()) {
                log.debug("No instances of [" + InvocationResultHandler.class.getName() + "] were registered to handing binding invocation result [" + result + "]");
            }
            for (InvocationResultHandler handler : providers) {
                handler.handle(event, context, result);
            }
        }
    }

    public static OperationBuilder binding(Retrieval retrieval) {
        return new Invoke(null, retrieval);
    }

    public static OperationBuilder binding(Submission to, Retrieval from) {
        return new Invoke(to, from);
    }
}

