/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config;

import com.ocpsoft.rewrite.config.Operation;
import com.ocpsoft.rewrite.config.OperationBuilder;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.event.Rewrite;
import com.ocpsoft.rewrite.servlet.config.DispatchType;
import com.ocpsoft.rewrite.servlet.config.encodequery.Base64EncodingStrategy;
import com.ocpsoft.rewrite.servlet.config.encodequery.ChecksumStrategy;
import com.ocpsoft.rewrite.servlet.config.encodequery.EncodingStrategy;
import com.ocpsoft.rewrite.servlet.config.encodequery.HashCodeChecksumStrategy;
import com.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import com.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import com.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import com.ocpsoft.rewrite.servlet.util.URLBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EncodeQuery
implements Operation {
    private String tokenName;
    private ChecksumStrategy checksumStrategy = new HashCodeChecksumStrategy();
    private EncodingStrategy encodingStrategy = new Base64EncodingStrategy();
    private final List<String> params = new ArrayList<String>();
    private final List<String> excludedParams = new ArrayList<String>();
    private boolean inboundCorrection = true;
    private Operation onfailure;

    private EncodeQuery(String[] params) {
        if (params != null && params.length > 0) {
            this.params.addAll(Arrays.asList(params));
        }
    }

    public static EncodeQuery params(String ... params) {
        return new EncodeQuery(params);
    }

    public EncodeQuery excluding(String ... params) {
        if (params != null && params.length > 0) {
            this.excludedParams.addAll(Arrays.asList(params));
        }
        return this;
    }

    public EncodeQuery withEncodingStrategy(EncodingStrategy strategy) {
        this.encodingStrategy = strategy;
        return this;
    }

    public EncodeQuery withChecksumStrategy(ChecksumStrategy strategy) {
        this.checksumStrategy = strategy;
        return this;
    }

    public EncodeQuery withInboundCorrection(boolean enable) {
        this.inboundCorrection = enable;
        return this;
    }

    public OperationBuilder onChecksumFailure(final Operation operation) {
        OperationBuilder builder = new OperationBuilder(){

            @Override
            public void perform(Rewrite event, EvaluationContext context) {
                operation.perform(event, context);
            }
        };
        this.onfailure = builder;
        return builder;
    }

    public EncodeQuery to(String param) {
        this.tokenName = param;
        return this;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite && DispatchType.isRequest().evaluate(event, context)) {
            HttpInboundServletRewrite in = (HttpInboundServletRewrite)event;
            QueryStringBuilder query = QueryStringBuilder.begin();
            query.addParameters(in.getRequestQueryString());
            String token = query.decode().getParameter(this.tokenName);
            if (token != null) {
                String decoded = this.encodingStrategy.decode(token);
                if (this.checksumStrategy.checksumValid(decoded)) {
                    decoded = this.checksumStrategy.removeChecksum(decoded);
                    query.removeParameter(this.tokenName);
                    String newUrl = in.getRequestPath() + "?" + decoded;
                    in.forward(newUrl);
                } else if (this.onfailure != null) {
                    this.onfailure.perform(event, context);
                }
            } else if (!query.isEmpty() && this.inboundCorrection) {
                String encoded = this.checksumStrategy.embedChecksum(in.getRequestQueryString());
                encoded = this.encodingStrategy.encode(encoded);
                in.redirectTemporary(in.getContextPath() + in.getURL());
            }
        } else if (event instanceof HttpOutboundServletRewrite) {
            HttpOutboundServletRewrite out = (HttpOutboundServletRewrite)event;
            String outboundURL = out.getOutboundURL();
            URLBuilder url = URLBuilder.build(outboundURL);
            url.getQueryStringBuilder().removeParameter(this.tokenName);
            if (outboundURL.contains("?") && (outboundURL.startsWith(out.getContextPath()) || outboundURL.startsWith("/")) && !url.getQueryStringBuilder().isEmpty()) {
                String encoded = this.checksumStrategy.embedChecksum(url.getQueryStringBuilder().toQueryString());
                encoded = this.encodingStrategy.encode(encoded);
                out.setOutboundURL(url.toPath() + "?" + this.tokenName + "=" + encoded);
            }
        }
    }
}

