/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config;

import com.ocpsoft.common.util.Assert;
import com.ocpsoft.rewrite.bind.Binding;
import com.ocpsoft.rewrite.bind.Evaluation;
import com.ocpsoft.rewrite.bind.ParameterizedPattern;
import com.ocpsoft.rewrite.bind.RegexOperationParameterBuilder;
import com.ocpsoft.rewrite.bind.RegexParameter;
import com.ocpsoft.rewrite.bind.parse.CaptureType;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.param.OperationParameterBuilder;
import com.ocpsoft.rewrite.param.ParameterizedOperation;
import com.ocpsoft.rewrite.servlet.config.HttpOperation;
import com.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import com.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Forward
extends HttpOperation
implements ParameterizedOperation<OperationParameterBuilder<RegexOperationParameterBuilder, String>, String> {
    private final ParameterizedPattern location;

    private Forward(String location) {
        Assert.notNull(location, "Location must not be null.");
        this.location = new ParameterizedPattern(CaptureType.BRACE, "[^/]+", location);
        for (RegexParameter parameter : this.location.getParameters().values()) {
            parameter.bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Forward to(String location) {
        return new Forward(location);
    }

    @Override
    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build(event, context);
            ((HttpInboundServletRewrite)event).forward(target);
        }
    }

    @Override
    public RegexOperationParameterBuilder where(String param) {
        return new RegexOperationParameterBuilder(this, this.location.getParameter(param));
    }

    @Override
    public RegexOperationParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public RegexOperationParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexOperationParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public RegexOperationParameterBuilder where(String param, Binding binding) {
        return (RegexOperationParameterBuilder)this.where(param).bindsTo(binding);
    }
}

