/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config;

import com.ocpsoft.common.util.Assert;
import com.ocpsoft.rewrite.bind.Bindings;
import com.ocpsoft.rewrite.bind.ParameterizedPattern;
import com.ocpsoft.rewrite.bind.RegexParameter;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.event.Rewrite;
import com.ocpsoft.rewrite.servlet.config.HttpCondition;
import com.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Header
extends HttpCondition {
    private final ParameterizedPattern name;
    private final ParameterizedPattern value;

    private Header(String name, String value) {
        Assert.notNull(name, "Header name pattern cannot be null.");
        Assert.notNull(value, "Header value pattern cannot be null.");
        this.name = new ParameterizedPattern(name);
        this.value = new ParameterizedPattern(value);
    }

    public static Header matches(String name, String value) {
        return new Header(name, value);
    }

    public static Header exists(String name) {
        return new Header(name, ".*");
    }

    public static Header valueExists(String value) {
        return new Header(".*", value);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String header : Collections.list(request.getHeaderNames())) {
            if (!this.name.matches(event, context, header) || !this.matchesValue(event, context, request, header)) continue;
            Map<RegexParameter, String[]> parameters = this.name.parse(event, context, header);
            parameters = this.value.parse(event, context, header);
            if (!Bindings.enqueuePreOperationSubmissions(event, context, parameters) || !Bindings.enqueuePreOperationSubmissions(event, context, parameters)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Collections.list(request.getHeaders(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }
}

