/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config;

import com.ocpsoft.rewrite.bind.Bindable;
import com.ocpsoft.rewrite.bind.Binding;
import com.ocpsoft.rewrite.bind.Bindings;
import com.ocpsoft.rewrite.bind.DefaultBindable;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.servlet.config.HttpCondition;
import com.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class Method
extends HttpCondition
implements Bindable<Method> {
    private final HttpMethod method;
    private final DefaultBindable<?> bindable = new DefaultBindable();

    private Method(HttpMethod method) {
        this.method = method;
    }

    public static Method isGet() {
        return new Method(HttpMethod.GET);
    }

    public static Method isPost() {
        return new Method(HttpMethod.POST);
    }

    public static Method isHead() {
        return new Method(HttpMethod.HEAD);
    }

    public static Method isOptions() {
        return new Method(HttpMethod.OPTIONS);
    }

    public static Method isPut() {
        return new Method(HttpMethod.PUT);
    }

    public static Method isDelete() {
        return new Method(HttpMethod.DELETE);
    }

    public static Method isTrace() {
        return new Method(HttpMethod.TRACE);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.method.equals((Object)HttpMethod.valueOf(((HttpServletRequest)event.getRequest()).getMethod()))) {
            Bindings.enqueueSubmission(event, context, this.bindable, this.method.name());
            return true;
        }
        return false;
    }

    @Override
    public Method bindsTo(Binding binding) {
        this.bindable.bindsTo(binding);
        return this;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindable.getBindings();
    }

    private static enum HttpMethod {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        DELETE,
        TRACE;

    }
}

