/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config;

import com.ocpsoft.common.util.Assert;
import com.ocpsoft.rewrite.bind.Binding;
import com.ocpsoft.rewrite.bind.Bindings;
import com.ocpsoft.rewrite.bind.DefaultBindable;
import com.ocpsoft.rewrite.bind.Evaluation;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.servlet.config.HttpCondition;
import com.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class RequestParameter
extends HttpCondition {
    private final String name;
    private final Pattern nameRegex;
    private final Pattern value;
    private final DefaultBindable<?> bindable = new DefaultBindable();

    private RequestParameter(String name, String nameRegex, String valueRegex) {
        Assert.notNull(nameRegex, "Parameter name pattern cannot be null.");
        Assert.notNull(valueRegex, "Parameter value pattern cannot be null.");
        this.name = name;
        this.nameRegex = Pattern.compile(nameRegex);
        this.value = Pattern.compile(valueRegex);
        this.bindsTo(Evaluation.property(nameRegex));
    }

    public RequestParameter bindsTo(Binding binding) {
        this.bindable.bindsTo(binding);
        return this;
    }

    public static RequestParameter matches(String nameRegex, String valueRegex) {
        return new RequestParameter(null, nameRegex, valueRegex);
    }

    public static RequestParameter exists(String name) {
        return new RequestParameter(name, name, ".*");
    }

    public static RequestParameter existsMatching(String nameRegex) {
        return new RequestParameter(null, nameRegex, ".*");
    }

    public static RequestParameter valueExists(String valueRegex) {
        return new RequestParameter(null, ".*", valueRegex);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String matchedParameter = null;
        ArrayList<String> values = new ArrayList<String>();
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String parameter : Collections.list(request.getParameterNames())) {
            if (this.name != null) {
                if (!this.name.equals(parameter)) continue;
                matchedParameter = this.name;
                values.addAll(Arrays.asList(request.getParameterValues(matchedParameter)));
                break;
            }
            if (!this.nameRegex.matcher(parameter).matches() || !this.matchesValue(request, parameter)) continue;
            matchedParameter = parameter;
            values.addAll(Arrays.asList(request.getParameterValues(matchedParameter)));
        }
        if (matchedParameter != null) {
            Bindings.enqueueSubmission(event, context, this.bindable, values.toArray(new String[0]));
            return true;
        }
        return false;
    }

    private boolean matchesValue(HttpServletRequest request, String parameter) {
        for (String contents : Arrays.asList(request.getParameterValues(parameter))) {
            if (!this.value.matcher(contents).matches()) continue;
            return true;
        }
        return false;
    }
}

