/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config;

import com.ocpsoft.common.util.Assert;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.servlet.config.HttpCondition;
import com.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import javax.servlet.http.HttpServletRequest;

public class ServerPort
extends HttpCondition {
    private final int[] ports;

    private ServerPort(int ... ports) {
        Assert.notNull(ports, "Must specify at least one valid port.");
        for (int port : ports) {
            if (port >= 1 && port <= 65535) continue;
            throw new IllegalArgumentException("Invalid port number: " + ports + " - must be between 1 and 65535, inclusive.");
        }
        this.ports = ports;
    }

    public static ServerPort is(int ... ports) {
        return new ServerPort(ports);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        int serverPort = ((HttpServletRequest)event.getRequest()).getServerPort();
        for (int port : this.ports) {
            if (serverPort != port) continue;
            return true;
        }
        return false;
    }
}

