/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config.encodequery;

import com.ocpsoft.rewrite.servlet.config.encodequery.ChecksumStrategy;

public class HashCodeChecksumStrategy
implements ChecksumStrategy {
    private static final String CHECKSUM_DELIM = "#";

    @Override
    public boolean checksumValid(String token) {
        if (token.contains(CHECKSUM_DELIM)) {
            Integer storedHashCode;
            int hashCode = token.substring(token.indexOf(CHECKSUM_DELIM) + 1).hashCode();
            return hashCode == (storedHashCode = Integer.valueOf(token.substring(0, token.indexOf(CHECKSUM_DELIM))));
        }
        return false;
    }

    @Override
    public String embedChecksum(String token) {
        String result = token.hashCode() + CHECKSUM_DELIM + token;
        return result;
    }

    @Override
    public String removeChecksum(String token) {
        String result = token.substring(token.indexOf(CHECKSUM_DELIM) + 1);
        return result;
    }
}

