/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config.rule;

import com.ocpsoft.rewrite.bind.Binding;
import com.ocpsoft.rewrite.bind.RegexParameter;
import com.ocpsoft.rewrite.config.Condition;
import com.ocpsoft.rewrite.config.ConditionBuilder;
import com.ocpsoft.rewrite.config.Operation;
import com.ocpsoft.rewrite.config.Rule;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.event.Rewrite;
import com.ocpsoft.rewrite.param.Parameterized;
import com.ocpsoft.rewrite.servlet.config.DispatchType;
import com.ocpsoft.rewrite.servlet.config.Forward;
import com.ocpsoft.rewrite.servlet.config.Path;
import com.ocpsoft.rewrite.servlet.config.QueryString;
import com.ocpsoft.rewrite.servlet.config.Redirect;
import com.ocpsoft.rewrite.servlet.config.Substitute;
import com.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import com.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import com.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class Join
implements Rule,
Parameterized<JoinParameterBuilder, String> {
    private static final String CURRENT_JOIN = Join.class.getName() + "_current";
    private String id;
    private final String pattern;
    private String resource;
    private Path resourcePath;
    private final Path path;
    private Operation operation;
    private Condition condition;
    private boolean inboundCorrection = false;

    protected Join(String pattern) {
        this.pattern = pattern;
        this.path = Path.matches(pattern);
    }

    public static Join path(String pattern) {
        return new Join(pattern);
    }

    public Join to(String resource) {
        this.resource = resource;
        this.resourcePath = Path.matches(resource);
        return this;
    }

    public Join withInboundCorrection() {
        this.inboundCorrection = true;
        return this;
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            this.path.withRequestBinding();
            if (this.path.evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                if (this.operation != null) {
                    context.addPreOperation(this.operation);
                }
                return true;
            }
            if (this.inboundCorrection && this.resourcePath.andNot(DispatchType.isForward()).evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                List<String> names = this.path.getPathExpression().getParameterNames();
                for (String name : names) {
                    if (QueryString.parameterExists(name).evaluate(event, context)) continue;
                    return false;
                }
                context.addPreOperation(Redirect.permanent(((HttpInboundServletRewrite)event).getContextPath() + this.pattern));
                return true;
            }
        } else if (event instanceof HttpOutboundServletRewrite) {
            List<String> parameters = this.getPathRequestParameters();
            ConditionBuilder outbound = this.resourcePath;
            for (String name : parameters) {
                outbound = outbound.and(QueryString.parameterExists(name));
            }
            if (outbound.evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                if (this.operation != null) {
                    context.addPreOperation(this.operation);
                }
                return true;
            }
        }
        return false;
    }

    private List<String> getPathRequestParameters() {
        List<String> nonQueryParameters = this.resourcePath.getPathExpression().getParameterNames();
        List<String> queryParameters = this.path.getPathExpression().getParameterNames();
        queryParameters.removeAll(nonQueryParameters);
        return queryParameters;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            this.saveCurrentJoin((HttpServletRequest)((HttpInboundServletRewrite)event).getRequest());
            Forward.to(this.resource).perform(event, context);
        } else if (event instanceof HttpOutboundServletRewrite) {
            List<String> parameters = this.getPathRequestParameters();
            String outboundURL = ((HttpOutboundServletRewrite)event).getOutboundURL();
            QueryStringBuilder query = QueryStringBuilder.begin();
            if (outboundURL.contains("?")) {
                query.addParameters(outboundURL);
                for (String string : parameters) {
                    List<String> values = query.removeParameter(string);
                    if (values.size() <= 1) continue;
                    query.addParameter(string, values.subList(1, values.size()).toArray(new String[0]));
                }
            }
            Substitute.with(this.pattern + query.toQueryString()).perform(event, context);
        }
    }

    private void saveCurrentJoin(HttpServletRequest request) {
        request.setAttribute(CURRENT_JOIN, (Object)this);
    }

    public static Join getCurrentJoin(HttpServletRequest request) {
        return (Join)request.getAttribute(CURRENT_JOIN);
    }

    @Override
    public JoinParameterBuilder where(String parameter) {
        return new JoinParameterBuilder(this, this.path.getPathExpression().getParameter(parameter));
    }

    @Override
    public JoinParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public JoinParameterBuilder where(String param, String pattern, Binding binding) {
        return this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public JoinParameterBuilder where(String param, Binding binding) {
        return this.where(param).bindsTo(binding);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Join when(Condition condition) {
        this.condition = condition;
        return this;
    }

    public Join perform(Operation operation) {
        this.operation = operation;
        return this;
    }

    public Join withId(String id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "Join [url=" + this.pattern + ", to=" + this.resource + ", id=" + this.id + ", inboundCorrection=" + this.inboundCorrection + "]";
    }

    public class JoinParameterBuilder
    implements Parameterized<JoinParameterBuilder, String>,
    Rule {
        private final Join parent;
        private final RegexParameter parameter;

        public JoinParameterBuilder(Join link, RegexParameter parameter) {
            this.parent = link;
            this.parameter = parameter;
        }

        public Join to(String resource) {
            return this.parent.to(resource);
        }

        public JoinParameterBuilder matches(String pattern) {
            this.parameter.matches(pattern);
            return this;
        }

        public JoinParameterBuilder bindsTo(Binding binding) {
            this.parameter.bindsTo(binding);
            return this;
        }

        @Override
        public JoinParameterBuilder where(String param) {
            return this.parent.where(param);
        }

        @Override
        public JoinParameterBuilder where(String param, String pattern) {
            return this.parent.where(param, pattern);
        }

        @Override
        public JoinParameterBuilder where(String param, String pattern, Binding binding) {
            return this.parent.where(param, pattern, binding);
        }

        @Override
        public JoinParameterBuilder where(String param, Binding binding) {
            return this.parent.where(param, binding);
        }

        public Join when(Condition condition) {
            return this.parent.when(condition);
        }

        public Join perform(Operation operation) {
            return this.parent.perform(operation);
        }

        @Override
        public String getId() {
            return this.parent.getId();
        }

        @Override
        public boolean evaluate(Rewrite event, EvaluationContext context) {
            return this.parent.evaluate(event, context);
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            this.parent.perform(event, context);
        }
    }
}

