/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.config.rule;

import com.ocpsoft.rewrite.config.Condition;
import com.ocpsoft.rewrite.config.Direction;
import com.ocpsoft.rewrite.config.Operation;
import com.ocpsoft.rewrite.config.Rule;
import com.ocpsoft.rewrite.context.EvaluationContext;
import com.ocpsoft.rewrite.event.InboundRewrite;
import com.ocpsoft.rewrite.event.OutboundRewrite;
import com.ocpsoft.rewrite.event.Rewrite;
import com.ocpsoft.rewrite.servlet.config.Path;
import com.ocpsoft.rewrite.servlet.config.Redirect;
import com.ocpsoft.rewrite.servlet.config.Substitute;
import com.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class TrailingSlash
implements Rule {
    private String id;
    protected Operation operation;
    protected Condition condition;

    public static TrailingSlash remove() {
        return new RemoveTrailingSlash();
    }

    public static TrailingSlash append() {
        return new AppendTrailingSlash();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public TrailingSlash when(Condition condition) {
        this.condition = condition;
        return this;
    }

    public TrailingSlash performInbound(Operation operation) {
        this.operation = operation;
        return this;
    }

    public TrailingSlash withId(String id) {
        this.id = id;
        return this;
    }

    private static class RemoveTrailingSlash
    extends TrailingSlash {
        private RemoveTrailingSlash() {
        }

        @Override
        public boolean evaluate(Rewrite event, EvaluationContext context) {
            if (this.condition == null || this.condition.evaluate(event, context)) {
                if (Direction.isInbound().and(Path.matches("/{path}/").where("path").matches(".*")).evaluate(event, context)) {
                    if (this.operation != null) {
                        context.addPreOperation(this.operation);
                    }
                    return true;
                }
                if (Direction.isOutbound().and(Path.matches("/{path}/").where("path").matches(".*")).evaluate(event, context)) {
                    if (this.operation != null) {
                        context.addPreOperation(this.operation);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            if (event instanceof InboundRewrite) {
                Redirect.permanent(((HttpServletRewrite)event).getContextPath() + "/{path}").perform(event, context);
            } else if (event instanceof OutboundRewrite) {
                Substitute.with(((HttpServletRewrite)event).getContextPath() + "/{path}").perform(event, context);
            }
        }
    }

    private static class AppendTrailingSlash
    extends TrailingSlash {
        private AppendTrailingSlash() {
        }

        @Override
        public boolean evaluate(Rewrite event, EvaluationContext context) {
            if (this.condition == null || this.condition.evaluate(event, context)) {
                if (Direction.isInbound().and(Path.matches("/{path}").where("path").matches(".*[^/]")).evaluate(event, context)) {
                    if (this.operation != null) {
                        context.addPreOperation(this.operation);
                    }
                    return true;
                }
                if (Direction.isOutbound().and(Path.matches("/{path}").where("path").matches(".*[^/]")).evaluate(event, context)) {
                    if (this.operation != null) {
                        context.addPreOperation(this.operation);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            if (event instanceof InboundRewrite) {
                Redirect.permanent(((HttpServletRewrite)event).getContextPath() + "/{path}/").perform(event, context);
            } else if (event instanceof OutboundRewrite) {
                Substitute.with(((HttpServletRewrite)event).getContextPath() + "/{path}/").perform(event, context);
            }
        }
    }
}

