/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.event;

import com.ocpsoft.rewrite.context.Context;
import com.ocpsoft.rewrite.exception.RewriteException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class BaseRewrite<IN extends ServletRequest, OUT extends ServletResponse> {
    private IN request;
    private OUT response;
    protected Flow flow = Flow.UN_HANDLED;
    protected String dispatchResource;

    public BaseRewrite(IN request, OUT response) {
        this.request = request;
        this.response = response;
    }

    public void abort() {
        this.flow = Flow.ABORT_REQUEST;
    }

    public void proceed() {
        this.flow = Flow.PROCEED;
    }

    public void handled() {
        this.flow = Flow.HANDLED;
    }

    public void include(String resource) {
        this.dispatchResource = resource;
        this.flow = Flow.INCLUDE;
    }

    public void forward(String resource) {
        this.dispatchResource = resource;
        this.flow = Flow.FORWARD;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public String getDispatchResource() {
        return this.dispatchResource;
    }

    public IN getRequest() {
        return this.request;
    }

    public OUT getResponse() {
        return this.response;
    }

    public void setRequest(IN request) {
        this.request = request;
    }

    public void setResponse(OUT response) {
        this.response = response;
    }

    public String toString() {
        return "Rewrite [flow=" + (Object)((Object)this.flow) + ", dispatchResource=" + this.dispatchResource + "]";
    }

    public Context getRewriteContext() {
        Context context = (Context)this.request.getAttribute("_com.ocpsoft.rewrite.RequestContext");
        if (context == null) {
            throw new RewriteException("RewriteContext was null. Something is seriously wrong, or you are attempting to access this event outside of the Rewrite lifecycle.");
        }
        return context;
    }

    public static enum Flow {
        UN_HANDLED(null),
        HANDLED(null),
        CONTINUE(HANDLED),
        PROCEED(CONTINUE),
        INCLUDE(HANDLED),
        ABORT_REQUEST(HANDLED),
        FORWARD(ABORT_REQUEST),
        CHAIN(HANDLED);

        private Flow parent;

        private Flow(Flow flow) {
            this.parent = flow;
        }

        public boolean is(Flow other) {
            if (other == null) {
                return false;
            }
            Flow t = this;
            while (t != null) {
                if (other == t) {
                    return true;
                }
                t = t.parent;
            }
            return false;
        }

        public boolean contains(Flow other) {
            if (other == null) {
                return false;
            }
            Flow t = other;
            while (t != null) {
                if (this == t) {
                    return true;
                }
                t = t.parent;
            }
            return false;
        }
    }
}

