/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.rewrite.servlet.util;

import com.ocpsoft.common.util.Strings;
import com.ocpsoft.rewrite.servlet.util.Metadata;
import com.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class URLBuilder {
    private Metadata metadata = new Metadata();
    private final List<String> segments = new ArrayList<String>();
    private QueryStringBuilder query = QueryStringBuilder.begin();

    public static URLBuilder begin() {
        return new URLBuilder();
    }

    public static URLBuilder build(List<String> segments, Metadata metadata) {
        return URLBuilder.begin().addPathSegments(segments).setMetadata(metadata);
    }

    public static URLBuilder build(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        if (url.contains("?")) {
            String[] parts = url.split("\\?");
            String path = parts[0];
            String query = parts[1];
            if (parts.length > 2) {
                query = Strings.join(Arrays.asList(Arrays.copyOfRange(parts, 1, parts.length)), "?");
            }
            return new URLBuilder().addPathSegments(path).addQueryParameters(query);
        }
        return new URLBuilder().addPathSegments(url);
    }

    private URLBuilder() {
    }

    public URLBuilder(List<String> encodedSegments, Metadata metadata, QueryStringBuilder query) {
        this.segments.addAll(encodedSegments);
        this.metadata = metadata.copy();
        this.query = query;
    }

    public URLBuilder addPathSegments(List<String> segments) {
        this.segments.addAll(segments);
        return this;
    }

    public URLBuilder addPathSegments(String path) {
        if (path != null) {
            String temp = path.trim();
            if (temp.endsWith("/")) {
                this.metadata.setTrailingSlash(true);
            }
            if (temp.startsWith("/") && this.segments.isEmpty()) {
                this.metadata.setLeadingSlash(true);
            }
        } else {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        String trimmedUrl = this.trimSurroundingSlashes(path);
        String[] newSegments = trimmedUrl.split("/");
        this.segments.addAll(Arrays.asList(newSegments));
        return this;
    }

    public URLBuilder addQueryParameters(String query) {
        this.query.addParameters(query);
        return this;
    }

    public URLBuilder decode() {
        return new URLBuilder(this.getDecodedSegments(), this.metadata, this.query.decode());
    }

    private String decodeSegment(String segment) {
        try {
            String prepared = ("http://localhost/" + segment).replaceAll(" ", "%20").replaceAll("\\+", "%20");
            URI uri = new URI(prepared);
            return uri.getPath().substring(1);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URLBuilder encode() {
        return new URLBuilder(this.getEncodedSegments(), this.metadata, this.query.encode());
    }

    private String encodeSegment(String segment) {
        try {
            URI uri = new URI("http", "localhost", "/" + segment, null);
            return uri.toASCIIString().substring(17);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<String> getDecodedSegments() {
        ArrayList<String> result = new ArrayList<String>();
        for (String segment : this.segments) {
            result.add(this.decodeSegment(segment));
        }
        return result;
    }

    private List<String> getEncodedSegments() {
        ArrayList<String> resultSegments = new ArrayList<String>();
        for (String segment : this.segments) {
            resultSegments.add(this.encodeSegment(segment));
        }
        return resultSegments;
    }

    public String getEncoding() {
        return this.metadata.getEncoding();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public QueryStringBuilder getQueryStringBuilder() {
        return this.query;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public boolean hasLeadingSlash() {
        return this.metadata.hasLeadingSlash();
    }

    public boolean hasTrailingSlash() {
        return this.metadata.hasTrailingSlash();
    }

    public int numSegments() {
        return this.segments.size();
    }

    public void setEncoding(String encoding) {
        this.metadata.setEncoding(encoding);
    }

    public URLBuilder setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public String toPath() {
        return this.metadata.buildURLFromSegments(this.segments);
    }

    public String toString() {
        return this.toURL();
    }

    public URI toURI() {
        try {
            URI uri = new URI(this.toURL());
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URL cannot be parsed.", e);
        }
    }

    public String toURL() {
        return this.toPath() + this.query.toQueryString();
    }

    private String trimSurroundingSlashes(String url) {
        String result = null;
        if (url != null) {
            result = url.trim();
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }
}

