/*
 * Decompiled with CFR 0.152.
 */
package org.docopt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Python {
    public static boolean bool(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            if (o instanceof Integer) {
                return !((Integer)o).equals(0);
            }
            if (o instanceof Long) {
                return !((Long)o).equals(0L);
            }
            if (o instanceof Double) {
                return !((Double)o).equals(0.0);
            }
            if (o instanceof Float) {
                return !((Float)o).equals(Float.valueOf(0.0f));
            }
            if (o instanceof Byte) {
                return !((Byte)o).equals((byte)0);
            }
            if (o instanceof Short) {
                return !((Short)o).equals((short)0);
            }
            if (o instanceof AtomicInteger) {
                return Python.bool(((AtomicInteger)o).get());
            }
            if (o instanceof AtomicLong) {
                return Python.bool(((AtomicLong)o).get());
            }
            if (o instanceof BigDecimal) {
                return !BigDecimal.ZERO.equals(o);
            }
            if (o instanceof BigInteger) {
                return !BigInteger.ZERO.equals(o);
            }
            throw new IllegalArgumentException("unknown numeric type: " + o.getClass());
        }
        if (o instanceof String) {
            return !"".equals(o);
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length != 0;
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        return true;
    }

    public static <T> boolean in(T left, T ... right) {
        for (T o : right) {
            if (!(left != null ? left.equals(o) : o == null)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> plus(List<T> a, List<T> b) {
        ArrayList<T> c = new ArrayList<T>(a.size() + b.size());
        c.addAll(a);
        c.addAll(b);
        return c;
    }

    public static String repr(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof Object[]) {
            return Arrays.toString((Object[])o);
        }
        return o.toString();
    }

    public static <T> List<T> list(Iterable<? extends T> elements) {
        List<T> list = Python.list();
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> list(T[] elements) {
        List<T> list = Python.list();
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> list(T element) {
        List<T> list = Python.list();
        list.add(element);
        return list;
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> int count(List<T> self, T obj) {
        int count = 0;
        for (T element : self) {
            if (!element.equals(obj)) continue;
            ++count;
        }
        return count;
    }

    public static <T> Set<T> set(Iterable<T> elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static String join(String self, Iterable<?> iterable) {
        Iterator<?> i = iterable.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (i.hasNext()) {
            sb.append(i.next());
            sb.append(self);
        }
        sb.setLength(sb.length() - self.length());
        return sb.toString();
    }

    public static String[] partition(String self, String sep) {
        int i = self.indexOf(sep);
        if (i == -1) {
            return new String[]{self, "", ""};
        }
        int j = i + sep.length();
        return new String[]{self.substring(0, i), sep, j < self.length() ? self.substring(j) : ""};
    }

    public static boolean isUpper(String self) {
        boolean result = false;
        for (char c : self.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            if (Character.isUpperCase(c)) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }

    public static List<String> split(String self) {
        return Python.list(self.trim().split("\\s+"));
    }

    private Python() {
    }

    static final class Re {
        public static final int IGNORECASE = 2;
        public static final int MULTILINE = 9;

        public static List<String> findAll(String pattern, String string, int flags) {
            return Re.findAll(Pattern.compile(pattern, flags), string);
        }

        public static List<String> findAll(Pattern pattern, String string) {
            Matcher matcher = pattern.matcher(string);
            List<String> result = Python.list();
            while (matcher.find()) {
                if (matcher.groupCount() == 0) {
                    result.add(matcher.group());
                    continue;
                }
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    String match = matcher.group(i + 1);
                    if (match == null) continue;
                    result.add(match);
                }
            }
            return result;
        }

        private static boolean hasGrouping(String pattern) {
            int i = -1;
            while ((i = pattern.indexOf(40, i + 1)) != -1) {
                int c = 0;
                for (int j = i - 1; j > -1 && pattern.charAt(j) == '\\'; --j) {
                    ++c;
                }
                if (c % 2 != 0) continue;
                return true;
            }
            return false;
        }

        public static List<String> split(String pattern, String string) {
            if (!Re.hasGrouping(pattern)) {
                return Python.list(string.split(pattern));
            }
            Matcher matcher = Pattern.compile(pattern, 0).matcher(string);
            List<String> matches = Python.list();
            int start = 0;
            while (matcher.find()) {
                matches.add(string.substring(start, matcher.start()));
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    matches.add(matcher.group(i + 1));
                }
                start = matcher.end();
            }
            matches.add(string.substring(start));
            return matches;
        }

        public static String sub(String pattern, String repl, String string) {
            return Pattern.compile(pattern, 0).matcher(string).replaceAll(repl);
        }

        private Re() {
        }
    }
}

