/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.MainView;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class JenkinsServer {
    private final JenkinsHttpClient client;

    public JenkinsServer(URI serverUri) {
        this(new JenkinsHttpClient(serverUri));
    }

    public JenkinsServer(URI serverUri, String username, String passwordOrToken) {
        this(new JenkinsHttpClient(serverUri, username, passwordOrToken));
    }

    public JenkinsServer(JenkinsHttpClient client) {
        this.client = client;
    }

    public Map<String, Job> getJobs() throws IOException {
        List<Job> jobs = this.client.get("/", MainView.class).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName().toLowerCase();
            }
        });
    }

    public void createJob(String jobName, String jobXml) throws IOException {
        this.client.post_xml("/createItem?name=" + jobName, jobXml);
    }

    public String getJobXml(String jobName) throws IOException {
        return this.client.get("/job/" + jobName + "/config.xml");
    }

    public void updateJob(String jobName, String jobXml) throws IOException {
        this.client.post_xml("/job/" + jobName + "/config.xml", jobXml);
    }
}

