/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.client;

import com.offbytwo.jenkins.client.PreemptiveAuth;
import com.offbytwo.jenkins.model.BaseModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class JenkinsHttpClient {
    private URI uri;
    private DefaultHttpClient client;
    private BasicHttpContext localContext;
    private ObjectMapper mapper;
    private String context;

    public JenkinsHttpClient(URI uri) {
        this.context = uri.getPath();
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.uri = uri;
        this.mapper = this.getDefaultMapper();
        this.client = new DefaultHttpClient();
    }

    public JenkinsHttpClient(URI uri, String username, String password) {
        this(uri);
        if (StringUtils.isNotBlank((String)username)) {
            CredentialsProvider provider = this.client.getCredentialsProvider();
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), "realm");
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            provider.setCredentials(scope, (Credentials)credentials);
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("preemptive-auth", (Object)new BasicScheme());
            this.client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> T get(String path, Class<T> cls) throws IOException, HttpResponseException {
        HttpResponse response = this.client.execute((HttpUriRequest)new HttpGet(this.api(path)), (HttpContext)this.localContext);
        int status = response.getStatusLine().getStatusCode();
        if (status < 200 || status >= 300) {
            throw new HttpResponseException(status, response.getStatusLine().getReasonPhrase());
        }
        try {
            T t = this.objectFromResponse(cls, response);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    public String get(String path) throws IOException, HttpResponseException {
        HttpResponse response = this.client.execute((HttpUriRequest)new HttpGet(this.api(path)), (HttpContext)this.localContext);
        int status = response.getStatusLine().getStatusCode();
        if (status < 200 || status >= 300) {
            throw new HttpResponseException(status, response.getStatusLine().getReasonPhrase());
        }
        Scanner s = new Scanner(response.getEntity().getContent());
        s.useDelimiter("\\z");
        StringBuffer sb = new StringBuffer();
        while (s.hasNext()) {
            sb.append(s.next());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls) throws IOException, HttpResponseException {
        HttpResponse response;
        int status;
        HttpPost request = new HttpPost(this.api(path));
        if (data != null) {
            StringEntity stringEntity = new StringEntity(this.mapper.writeValueAsString(data), "application/json");
            request.setEntity((HttpEntity)stringEntity);
        }
        if ((status = (response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext)).getStatusLine().getStatusCode()) < 200 || status >= 300) {
            throw new HttpResponseException(status, response.getStatusLine().getReasonPhrase());
        }
        try {
            if (cls != null) {
                R r = this.objectFromResponse(cls, response);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post_xml(String path, String xml_data) throws IOException, HttpResponseException {
        HttpResponse response;
        int status;
        HttpPost request = new HttpPost(this.api(path));
        if (xml_data != null) {
            request.setEntity((HttpEntity)new StringEntity(xml_data, ContentType.APPLICATION_XML));
        }
        if ((status = (response = this.client.execute((HttpUriRequest)request, (HttpContext)this.localContext)).getStatusLine().getStatusCode()) < 200 || status >= 300) {
            throw new HttpResponseException(status, response.getStatusLine().getReasonPhrase());
        }
        try {
            InputStream content = response.getEntity().getContent();
            Scanner s = new Scanner(content);
            StringBuffer sb = new StringBuffer();
            while (s.hasNext()) {
                sb.append(s.next());
            }
            String string = sb.toString();
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    public void post(String path) throws IOException, HttpResponseException {
        this.post(path, null, null);
    }

    private String urlJoin(String path1, String path2) {
        if (!path1.endsWith("/")) {
            path1 = path1 + "/";
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        return path1 + path2;
    }

    private URI api(String path) {
        if (!path.toLowerCase().matches("https?://.*")) {
            path = this.urlJoin(this.context, path);
        }
        if (!path.contains("?")) {
            path = this.urlJoin(path, "api/json");
        } else {
            String[] components = path.split("\\?", 2);
            path = this.urlJoin(components[0], "api/json") + "?" + components[1];
        }
        URI requestUri = this.uri.resolve("/").resolve(path);
        return requestUri;
    }

    private <T extends BaseModel> T objectFromResponse(Class<T> cls, HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        BaseModel result = (BaseModel)this.mapper.readValue(content, cls);
        result.setClient(this);
        return (T)result;
    }

    private ObjectMapper getDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        mapper.setDeserializationConfig(deserializationConfig.without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES}));
        return mapper;
    }
}

